package common.repository;

import common.model.*;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import tkio.model.Account;

import java.util.List;

@Transactional
public interface BackVisitRepository extends JpaRepository<BackVisit, Long> {

    @Query(value = "SELECT * from back_visit", nativeQuery = true)
    List<BackVisit> findAllCount();

    @Query(value = "select * from back_visit where account_id  = ?1 and ds >= ?2 and ds <= ?3 and platform = ?4", nativeQuery = true)
    List<BackVisit> findAll(Long accountId, String startDate, String endDate, String platform);

    @Query(value = "select * from back_visit where platform = ?1", nativeQuery = true)
    List<BackVisit> findAllByPlatform(String platform);
}
