package common.repository;

import common.model.Auth;
import common.model.Reminder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface ReminderRepository extends JpaRepository<Reminder, Long> {

    @Query(value = "select * from reminder where account_id  = ?1 and ds >= ?2 and ds <= ?3 and platform = ?4", nativeQuery = true)
    List<Reminder> findAll(Long accountId, String startDate, String endDate, String platform);

    @Query(value = "SELECT * from reminder where id in (select max(id) from reminder where platform = ?1 group by account_id )", nativeQuery = true)
    List<Reminder> findAllDistinct(String platform);

    @Query(value = "SELECT * from reminder where id in (select max(id) from reminder where platform = ?1 group by account_id ) and status = false", nativeQuery = true)
    List<Reminder> findAllDistinctFalse(String platform);
}
