package common.repository;

import common.model.Menu;
import common.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface UserRepository extends JpaRepository<User, Long> {

	@Query(value="select * from user where email = ?1 and password = ?2 and del_flag is not true",nativeQuery=true)
	User login(String email, String pwd);

	@Query(value="select * from user where role = ?1 and del_flag is not true",nativeQuery=true)
	List<User> findOneDepartment(Long role);

	@Query(value="select * from user where del_flag is not true",nativeQuery=true)
	List<User> findList();

	@Query(value="select * from user where email = ?1 and del_flag is not true",nativeQuery=true)
	User login(String email);

}
