package track.controller;

import common.model.BackVisit;
import common.model.Payment;
import common.model.Reminder;
import common.model.User;
import dic.OperateObjectTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import tkio.service.TkioAccountService;
import track.service.TrackAccountService;
import util.ResultModel;
import util.UserLogThread;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by mxq on 2017/12/21.
 */
@Controller
@RequestMapping("track/marketing/accountmng")
public class TrackAccountController {

    @Autowired
    TrackAccountService tkioAccountService;

    //客户列表
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel find(@CurrentAccount User loginAccount) {
        return ResultModel.OK(tkioAccountService.findAll(loginAccount));
    }

    //关闭到期提醒
    @RequestMapping(value = "/forbiden", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbiden(@CurrentAccount User loginAccount, @RequestBody Reminder resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "关闭到期提醒", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.forbiden(loginAccount, resource));
    }

    //开启到期提醒
    @RequestMapping(value = "/enable", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(@CurrentAccount User loginAccount, @RequestBody Reminder resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "开启到期提醒", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.enable(loginAccount, resource));
    }

    //缴费
    @RequestMapping(value = "/pay", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel pay(@CurrentAccount User loginAccount, @RequestBody Payment resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "缴费", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.pay(loginAccount, resource));
    }

    //回访
    @RequestMapping(value = "/visit", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel visit(@CurrentAccount User loginAccount, @RequestBody BackVisit resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "回访", request);
        userlog.start();
        return ResultModel.OK( tkioAccountService.visit(loginAccount, resource));
    }
    //功能使用查询
    @RequestMapping(value = "/find/function/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel updateName(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                  @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findFunTimes(accountId,startDate,endDate));
    }


    //到期提醒查询
    @RequestMapping(value = "/find/reminder/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findRed(@CurrentAccount User loginAccount, @RequestParam String startDate,
                          @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findRed(accountId,startDate,endDate));
    }

    //回访查询
    @RequestMapping(value = "/find/visit/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findVisit(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findVisit(accountId,startDate,endDate));
    }

    //缴费查询
    @RequestMapping(value = "/find/pay/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findPay(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findPay(accountId,startDate,endDate));
    }

}
