package util;

import com.google.common.base.Strings;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {

	private static final String URL_REGEX_PATTERN = "(http|https):\\/\\/[^\\s]+";
	private static final String NAME_REGEX_PATTERN = "^[a-zA-Z0-9\\s\\.\\-\\u4E00-\\u9FA5]+$";

	public static String[] toStrArray(String str) {
		return str.split(",");
	}

	/*
	 * 判断是否为整数
	 *
	 * @param str 传入的字符串
	 *
	 * @return 是整数返回true,否则返回false
	 */
	public static boolean isInteger(String str) {
		Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
		return pattern.matcher(str).matches();
	}

	/*
	 * 判断是否为浮点数，包括double和float
	 *
	 * @param str 传入的字符串
	 *
	 * @return 是浮点数返回true,否则返回false
	 */
	public static boolean isDouble(String str) {
		Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
		return pattern.matcher(str).matches();
	}

	public static boolean isNumber(String string) {
		return string.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
	}

	public static boolean isEmpty(String string) {

		return string == null || "".equals(string);
	}

	public static String escapeString(String old) {
		old = old.replace("'", "\\'");
		return old;
	}

	public static void main(String[] args) {
		String str = "点通";
		String pattern = "([广点通])|([百分点])|([乱七八糟])";

		Pattern r = Pattern.compile(pattern);
		Matcher m = r.matcher(str);
		System.out.println(m.group());
	}

	/**
	 * 随机获取user_agent
	 *
	 */
	public static String getUA() {
		String[] _user_agent_pc = {
				"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)",
				"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 6.0)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.1)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.0)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1)",

				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Maxthon 2.0)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; TencentTraveler 4.0)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; The World)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Avant Browser)",
				"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0)",

				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Maxthon 2.0)",
				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; TencentTraveler 4.0)",
				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; The World)",
				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; 360SE)",
				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Avant Browser)",
				"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)",

				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Maxthon 2.0)",
				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; TencentTraveler 4.0)",
				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; The World)",
				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; 360SE)",
				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Avant Browser)",
				"Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/4.0)",

				"Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; Maxthon 2.0)",
				"Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; TencentTraveler 4.0)",
				"Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; The World)",
				"Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)",
				"Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0)",

				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; Maxthon 2.0)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; TencentTraveler 4.0)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; The World)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; 360SE)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; Avant Browser)",
				"Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0)",

				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Maxthon 2.0)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; TencentTraveler 4.0)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; The World)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; 360SE)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Avant Browser)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/4.0)",

				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:2.0.1) Gecko/20100101 Firefox/4.0.1",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:39.0) Gecko/20100101 Firefox/39.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6) AppleWebKit/534.50 (KHTML, like Gecko) Version/5.1 Safari/534.50",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0 Safari/535.11",

				"Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1",
				"Mozilla/5.0 (Windows; U; Windows NT 6.1; en-us) AppleWebKit/534.50 (KHTML, like Gecko) Version/5.1 Safari/534.50",
				"Mozilla/5.0 (Windows NT 6.0; rv:2.0) Gecko/20100101 Firefox/4.0 Opera 12.14",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.0) Opera 12.14",
				"Mozilla/5.0 (Windows NT 5.1) Gecko/20100101 Firefox/14.0 Opera/12.0",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; de) Opera 11.51",
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0 Safari/537.36",
				"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2227.0 Safari/537.36",
				"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2227.0 Safari/537.36",
				"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2226.0 Safari/537.36",
				"Mozilla/5.0 (Windows NT 6.4; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2225.0 Safari/537.36",
				"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2225.0 Safari/537.36",
				"Mozilla/5.0 (MSIE 9.0; Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko QQBrowser/8.1.3886.400",
				"Mozilla/5.0 (MSIE 9.0; Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko QQBrowser/8.2.3638.400",
				"Mozilla/5.0 (MSIE 9.0; Windows NT 6.0; Trident/7.0; rv:11.0) like Gecko QQBrowser/8.3.4765.400",
				"Mozilla/5.0 (MSIE 9.0; Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko QQBrowser/9.1.3471.400",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer 3.4.0.12519)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer 3.5.0.12758)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer 4.0.0.13120)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer 4.2.0.13550)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer 5.0.0.14004)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer/6.1.0.8158)",
				"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; 2345Explorer/6.2.0.9202)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; UBrowser/5.0.1369.26)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; UBrowser/5.2.2603.1)",
				"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; UBrowser/5.4.4237.43)",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:34.0) Gecko/20100101 Firefox/34.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:36.0) Gecko/20100101 Firefox/36.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:37.0) Gecko/20100101 Firefox/37.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:38.0) Gecko/20100101 Firefox/38.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:39.0) Gecko/20100101 Firefox/39.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:40.0) Gecko/20100101 Firefox/40.0",
				"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:41.0) Gecko/20100101 Firefox/41.0",

				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/2.1.7.6 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/34.0.1847.11 YYE/3.6 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.111 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.115 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.152 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.107 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.46 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2478.0 Safari/537.36",
				"Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2498.0 Safari/537.36",

				"Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; en) Presto/2.8.131 Version/11.11",
				"Opera/9.80 (Windows NT 6.1; U; en) Presto/2.8.131 Version/11.11",
				"Opera/9.80 (X11; Linux i686; Ubuntu/14.10) Presto/2.12.388 Version/12.16",
				"Opera/9.80 (Windows NT 6.0) Presto/2.12.388 Version/12.14",
				"Opera/9.80 (Windows NT 6.1; WOW64; U; pt) Presto/2.10.229 Version/11.62",
				"Opera/9.80 (Windows NT 6.0; U; pl) Presto/2.10.229 Version/11.62",
				"Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; fr) Presto/2.9.168 Version/11.52",
				"Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; de) Presto/2.9.168 Version/11.52",
				"Opera/9.80 (Windows NT 5.1; U; en) Presto/2.9.168 Version/11.51",
				"Opera/9.80 (Windows NT 6.1; U; es-ES) Presto/2.9.181 Version/12.00",
				"Opera/9.80 (Windows NT 5.1; U; zh-sg) Presto/2.9.181 Version/12.00",
				"Opera/12.0 (Windows NT 5.2;U;en)Presto/22.9.168 Version/12.00",
				"Opera/12.0 (Windows NT 5.1;U;en)Presto/22.9.168 Version/12.00",
				"Opera/12.80 (Windows NT 5.1; U; en) Presto/2.10.289 Version/12.02" };

		int index = (int) (Math.random() * _user_agent_pc.length);
		return _user_agent_pc[index];
	}

    public static String getSql(String attr, String values, String operator, String type,String tableAlias) {

		StringBuilder eventSB = new StringBuilder();

		if (attr.equals("_cid")) {
			type = "number";
		}

		if (operator.contains("in")) {

			if (type.contains("string") || type.contains("date")) {

				String value = values.replace(",", "','");
				eventSB.append(" ").append(tableAlias).append(attr).append(" ").append(operator).append("('").append(value).append("') ");

			} else {

				eventSB.append(tableAlias).append(attr).append(" ").append(operator).append("(").append(values).append(") ");
			}

		} else if (operator.contains("between")) {

			if (type.contains("string") || type.contains("date")) {

                String value = values.replace(",", "' and '");
				eventSB.append(tableAlias).append(attr).append(" ").append(operator).append(" '").append(value).append("' ");

			} else {

				String value = values.replace(",", " and ");
				eventSB.append(tableAlias).append(attr).append(" ").append(operator).append(" ").append(value).append(" ");
			}

		} else {

            if (type.contains("string") || type.contains("date")) {

				eventSB.append(tableAlias).append(attr).append(" ").append(operator).append(" '").append(values).append("' ");

			} else {

				eventSB.append(tableAlias).append(attr).append(" ").append(operator).append(" ").append(values).append(" ");
			}
		}

		return eventSB.toString();
	}

	public static String conditionFormat(String str) {
		str = "'" + str.replaceAll(",", "','") + "'";
		return str;
	}


	/**
	 * URL校验
	 */
	public static boolean urlMatch(String str) {

		Pattern pattern = Pattern.compile(URL_REGEX_PATTERN);
		return pattern.matcher(str).matches();
	}

	/**
	 * 名字校验
	 */
	public static boolean nameMatch(String str) {

		Pattern pattern = Pattern.compile(NAME_REGEX_PATTERN);
		return pattern.matcher(str).matches();
	}


	/**
	 * 将Long List转换成String,逗号隔开
	 */
	public static String transList2String(List<Long> idList){

		StringBuilder stringBuilder = new StringBuilder();

		for(Long id : idList){
			stringBuilder.append(id).append(",");
		}

		return stringBuilder.length() > 0 ? stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(",")).toString() : stringBuilder.toString();
	}

	/**
	 * 将逗号分隔的string转换成Long的List
	 */
	public static List<Long> transString2LongList(String ids)
	{

		List<Long> resultList = new ArrayList<>();

		String[] idArray = toStrArray(ids);
		for (String id : idArray) {
			try {
				if (Strings.isNullOrEmpty(id)) {
					continue;
				}

				resultList.add(Long.parseLong(id));
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}

		return resultList;
	}
}
