package util;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.Collection;
import java.util.Map;

/**
 * 校验工具类
 * @author liruijie@reyun.com
 * @date 2015年11月24日
 */
public class ValidateUtil {

    /**
     * 判断string是否有效
     * @param str
     * @return
     */
    public static boolean isValid(String str) {
        if (str == null || "".equals(str.trim())) {
            return false;
        }
        return true;
    }

    /**
     * 判断集合的有效性
     * @param col
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static boolean isValid(Collection col) {
        if (col == null || col.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 判断map的有效性
     * @param map
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static boolean isValid(Map map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        return true;
    }

    /**
     * 判断数组有效性
     * @param arr
     * @return
     */
    public static boolean isValid(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        return true;
    }

    /**
     * 判断对象有效性
     * @param obj
     * @return
     */
    public static boolean isValid(Object obj) {
        if (obj == null) {
            return false;
        }
        return true;
    }

    public static boolean isValid(JSONArray obj) {
        if (obj == null) {
            return false;
        }
        if(obj.length()<1){
            return false;
        }
        return true;
    }


    public static boolean validNotChinese(String str){
        return str.matches("^[a-zA-Z0-9_][a-zA-Z0-9_-]*$");
    }


    public static void main(String[] args) throws JSONException {
        String s = "[]";
        JSONArray o = new JSONArray(s);
        boolean valid = isValid(o);
        System.out.println(valid);
    }
}


