package common.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by mxq on 2018/1/16.
 */
@Entity
public class Contract {
    private Long id;
    private String product;
    private String myBodyName;
    private String myBodyCode;
    private String customerBody;
    private String email; //客户主账号
    private String contractCode;
    private int codeNum;
    //是否首次签约
    private String contractType; // 0 首次签约 1 续签 2 合同变更
    private String startDate;
    private String endDate;
    //套餐
    private Long priceLevel;
    private String priceLevelName;
    private Double money; //合同金额
    private Double rebate; //

    private Long sale;
    //产品 trackingio or adi ...
    private String platform;
    private String status; // 作废  先回款待录入
    private String saleName;

    private Double payMoney; // 回款金额
    private Integer backStatus; //  1 未回款 2 部分回款 3 已回款
    private Long invoice;  // 开票次数
    private BigDecimal invoiceMoney;  // 发票金额
    private String createName; // 创建人NAME
    //合同类型 主套餐 or 增值套餐
    private String type;
    private Long priceName;
    private Boolean old;
    private Long extraFlow; // 优惠流量

    private Long modifyAccount;
    private Long createAccount;// 创建人id
    private Date modifyTime;
    private Date createTime;
    private String ds;
    private Boolean virtual;

    private Long firstBackId;//先回款记录的id

    private Long adjustmentFund;// 分摊收入调整金额 (*100的结果)
    private String adjustmentFundForm; // 表单提交的值（分摊收入调整金额）
    private Integer intervalUseDays;//区间使用天数
    private Long incomeExcludingTax; //不含税收入 (*100的结果)
    private Long intervaIncomeShare;//区间分摊收入(*100的结果)
    private Long incomeShareAll;//分摊总收入(*100的结果)
    private Long incomeGross;//累计总收入(*100的结果)合同自开始至选择的结束日期(分摊收入+调整金额)

    private Integer shareSign;//标记是否计算分摊收入 1 计算 0 不计算




    private String searchName;

    private List<String> customBodyNames;


    /**
     * 新增字段 20190427
     */
    private Long discountTimeLong; // 优惠时长
    private String customerShort;// 客户简称
    private String customerThird;// 三方客户
    private int tradeType; // 行业id
    private Long relationContract;// 关联合同id
    private String relationCode;// 关联合同编号
    private String hasDiscount;// 是否有优惠

    private String typeId;// 合同类型  （保密协议、框架合同、结算单）
    private String erroMessage;
    private String tradeName;

    private Long barrioId;//行政区域id
    private String barrioName;//行政区域名称
    private String belongGroup;//隶属集团

    private Double trackFlow;//流量，tkio的,万单位
    private Double unitPrice;//单价，tkio
    private Double clickFlow;//区间点击数，tkio
    private Boolean operate = true;

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getVirtual() {
        return virtual;
    }

    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    public Long getFirstBackId() {
        return firstBackId;
    }

    public void setFirstBackId(Long firstBackId) {
        this.firstBackId = firstBackId;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getMyBodyName() {
        return myBodyName;
    }

    public void setMyBodyName(String myBodyName) {
        this.myBodyName = myBodyName;
    }

    public String getMyBodyCode() {
        return myBodyCode;
    }

    public void setMyBodyCode(String myBodyCode) {
        this.myBodyCode = myBodyCode;
    }

    public String getCustomerBody() {
        return customerBody;
    }

    public void setCustomerBody(String customerBody) {
        this.customerBody = customerBody;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String stratDate) {
        this.startDate = stratDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getPriceLevel() {
        return priceLevel;
    }

    public void setPriceLevel(Long priceLevel) {
        this.priceLevel = priceLevel;
    }

    public Double getMoney() {
        return money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public Double getRebate() {
        return rebate;
    }

    public void setRebate(Double rebate) {
        this.rebate = rebate;
    }

    public Long getSale() {
        return sale;
    }

    public void setSale(Long sale) {
        this.sale = sale;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Long getModifyAccount() {
        return modifyAccount;
    }

    public void setModifyAccount(Long modifyAccount) {
        this.modifyAccount = modifyAccount;
    }

    public Long getCreateAccount() {
        return createAccount;
    }

    public void setCreateAccount(Long createAccount) {
        this.createAccount = createAccount;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDs() {
        return ds;
    }

    public void setDs(String ds) {
        this.ds = ds;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Double getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(Double payMoney) {
        this.payMoney = payMoney;
    }

    public Long getInvoice() {
        return invoice;
    }

    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }

    public void setInvoice(Long invoice) {
        this.invoice = invoice;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getOld() {
        return old;
    }

    public Long getExtraFlow() {
        return extraFlow;
    }

    public void setExtraFlow(Long extraFlow) {
        this.extraFlow = extraFlow;
    }

    public void setOld(Boolean old) {
        this.old = old;
    }

    public int getCodeNum() {
        return codeNum;
    }

    public void setCodeNum(int codeNum) {
        this.codeNum = codeNum;
    }

    @Transient
    public Long getPriceName() {
        return priceName;
    }

    public void setPriceName(Long priceName) {
        this.priceName = priceName;
    }

    @Transient
    public String getSaleName() {
        return saleName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }

    @Transient
    public String getPriceLevelName() {
        return priceLevelName;
    }

    public String getRelationCode() {
        return relationCode;
    }

    public void setRelationCode(String relationCode) {
        this.relationCode = relationCode;
    }

    @Transient
    public String getHasDiscount() {
        return hasDiscount;
    }

    public void setHasDiscount(String hasDiscount) {
        this.hasDiscount = hasDiscount;
    }

    @Transient
    public String getErroMessage() {
        return erroMessage;
    }

    public void setErroMessage(String erroMessage) {
        this.erroMessage = erroMessage;
    }

    public void setPriceLevelName(String priceLevelName) {
        this.priceLevelName = priceLevelName;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Long getDiscountTimeLong() {
        return discountTimeLong;
    }

    public void setDiscountTimeLong(Long discountTimeLong) {
        this.discountTimeLong = discountTimeLong;
    }

    public String getCustomerShort() {
        return customerShort;
    }

    public void setCustomerShort(String customerShort) {
        this.customerShort = customerShort;
    }

    public String getCustomerThird() {
        return customerThird;
    }

    public void setCustomerThird(String customerThird) {
        this.customerThird = customerThird;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public Long getRelationContract() {
        return relationContract;
    }

    public void setRelationContract(Long relationContract) {
        this.relationContract = relationContract;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @Transient
    public String getTradeName() {
        return tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    public Long getAdjustmentFund() {
        return adjustmentFund;
    }

    public void setAdjustmentFund(Long adjustmentFund) {
        this.adjustmentFund = adjustmentFund;
    }

    @Transient
    public Integer getIntervalUseDays() {
        return intervalUseDays;
    }

    public void setIntervalUseDays(Integer intervalUseDays) {
        this.intervalUseDays = intervalUseDays;
    }

    @Transient
    public Long getIncomeExcludingTax() {
        return incomeExcludingTax;
    }

    @Transient
    public void setIncomeExcludingTax(Long incomeExcludingTax) {
        this.incomeExcludingTax = incomeExcludingTax;
    }

    public Long getIntervaIncomeShare() {
        return intervaIncomeShare;
    }

    @Transient
    public void setIntervaIncomeShare(Long intervaIncomeShare) {
        this.intervaIncomeShare = intervaIncomeShare;
    }

    @Transient
    public Long getIncomeShareAll() {
        return incomeShareAll;
    }

    public void setIncomeShareAll(Long incomeShareAll) {
        this.incomeShareAll = incomeShareAll;
    }

    @Transient
    public String getAdjustmentFundForm() {
        return adjustmentFundForm;
    }

    public void setAdjustmentFundForm(String adjustmentFundForm) {
        this.adjustmentFundForm = adjustmentFundForm;
    }

    public Long getBarrioId() {
        return barrioId;
    }

    public void setBarrioId(Long barrioId) {
        this.barrioId = barrioId;
    }

    public String getBelongGroup() {
        return belongGroup;
    }

    public void setBelongGroup(String belongGroup) {
        this.belongGroup = belongGroup;
    }

    public Integer getBackStatus() {
        return backStatus;
    }

    public void setBackStatus(Integer backStatus) {
        this.backStatus = backStatus;
    }

    @Transient
    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    @Transient
    public List<String> getCustomBodyNames() {
        return customBodyNames;
    }

    public void setCustomBodyNames(List<String> customBodyNames) {
        this.customBodyNames = customBodyNames;
    }


    public Integer getShareSign() {
        return shareSign;
    }

    public void setShareSign(Integer shareSign) {
        this.shareSign = shareSign;
    }

    @Transient
    public String getBarrioName() {
        return barrioName;
    }

    public void setBarrioName(String barrioName) {
        this.barrioName = barrioName;
    }

    public Double getTrackFlow() {
        return trackFlow;
    }

    public void setTrackFlow(Double trackFlow) {
        this.trackFlow = trackFlow;
    }
    @Transient
    public Double getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Transient
    public Double getClickFlow() {
        return clickFlow;
    }

    public void setClickFlow(Double clickFlow) {
        this.clickFlow = clickFlow;
    }

    @Transient
    public Long getIncomeGross() {
        return incomeGross;
    }

    public void setIncomeGross(Long incomeGross) {
        this.incomeGross = incomeGross;
    }

    @Transient
    public Boolean getOperate() {
        return operate;
    }

    public void setOperate(Boolean operate) {
        this.operate = operate;
    }

    @Override
    public String toString() {
        return "Contract{" +
                "id=" + id +
                ", product='" + product + '\'' +
                ", myBodyName='" + myBodyName + '\'' +
                ", myBodyCode='" + myBodyCode + '\'' +
                ", customerBody='" + customerBody + '\'' +
                ", email='" + email + '\'' +
                ", contractCode='" + contractCode + '\'' +
                ", codeNum=" + codeNum +
                ", contractType='" + contractType + '\'' +
                ", startDate='" + startDate + '\'' +
                ", endDate='" + endDate + '\'' +
                ", priceLevel=" + priceLevel +
                ", priceLevelName='" + priceLevelName + '\'' +
                ", money=" + money +
                ", rebate=" + rebate +
                ", sale=" + sale +
                ", platform='" + platform + '\'' +
                ", status='" + status + '\'' +
                ", saleName='" + saleName + '\'' +
                ", payMoney=" + payMoney +
                ", backStatus=" + backStatus +
                ", invoice=" + invoice +
                ", invoiceMoney=" + invoiceMoney +
                ", createName='" + createName + '\'' +
                ", type='" + type + '\'' +
                ", priceName=" + priceName +
                ", old=" + old +
                ", extraFlow=" + extraFlow +
                ", modifyAccount=" + modifyAccount +
                ", createAccount=" + createAccount +
                ", modifyTime=" + modifyTime +
                ", createTime=" + createTime +
                ", ds='" + ds + '\'' +
                ", virtual=" + virtual +
                ", firstBackId=" + firstBackId +
                ", adjustmentFund=" + adjustmentFund +
                ", adjustmentFundForm='" + adjustmentFundForm + '\'' +
                ", intervalUseDays=" + intervalUseDays +
                ", incomeExcludingTax=" + incomeExcludingTax +
                ", intervaIncomeShare=" + intervaIncomeShare +
                ", incomeShareAll=" + incomeShareAll +
                ", shareSign=" + shareSign +
                ", searchName='" + searchName + '\'' +
                ", customBodyNames=" + customBodyNames +
                ", discountTimeLong=" + discountTimeLong +
                ", customerShort='" + customerShort + '\'' +
                ", customerThird='" + customerThird + '\'' +
                ", tradeType=" + tradeType +
                ", relationContract=" + relationContract +
                ", relationCode='" + relationCode + '\'' +
                ", hasDiscount='" + hasDiscount + '\'' +
                ", typeId='" + typeId + '\'' +
                ", erroMessage='" + erroMessage + '\'' +
                ", tradeName='" + tradeName + '\'' +
                ", barrioId=" + barrioId +
                ", belongGroup='" + belongGroup + '\'' +
                '}';
    }
}
