package exception;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import util.ResultModel;
import util.ResultStatus;

/**
 * Created by nolan on 18/11/2016.
 * description:
 */
@ControllerAdvice
public class GlobalExceptionAdvice {
    private Logger logger = LoggerFactory.getLogger(GlobalExceptionAdvice.class);

    @ExceptionHandler(TransferCurrentAccountException.class)
    public ResponseEntity<ResultModel> handleTransferCurrentAccountException(TransferCurrentAccountException ex) {
        logger.error("handleTransferCurrentAccountException......", ex);
//        ex.printStackTrace();
        return new ResponseEntity<ResultModel>(ResultModel.ERROR(ResultStatus.USERNAME_LOGIN_EXPIRE), HttpStatus.OK);
    }

    @ExceptionHandler(TipException.class)
    public ResponseEntity<ResultModel> handleTipException(TipException ex) {
        logger.error("handleTipException......", ex);
        ex.printStackTrace();
        return new ResponseEntity<ResultModel>(new ResultModel(-999, ex.getMessage()), HttpStatus.OK);
    }

  /*  @ExceptionHandler(RuntimeException.class)
    public ResponseEntity<ResultModel> handleRuntimeException(RuntimeException ex) {
        logger.error("handleRuntimeException......", ex);
        ex.printStackTrace();
        return new ResponseEntity<ResultModel>(new ResultModel(-999, ex.getMessage()), HttpStatus.EXPECTATION_FAILED);
    }*/

    @ExceptionHandler(Exception.class)
    public ResponseEntity<ResultModel> handleAllException(Exception ex) {
        logger.error("handleAllException......", ex);
        ex.printStackTrace();
        return new ResponseEntity<ResultModel>(new ResultModel(-999, ex.getMessage()), HttpStatus.EXPECTATION_FAILED);
    }
}
