package tkio.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Entity
public class App {

	private Long id;
	@NotNull
	private String name;
	private String platform;
	private String appGenre;
	private String appGenreName;
	private String gameGenre;
	//private String gameCategory;
	private String appkey;
	private String url;
	private Long account;
	private boolean sync;
	// private boolean isActive;
	private Long origiApp;
	private String bundleid;
	private String token;
	private String installtoken;
	private boolean regedbutton;

	private Date createTime = new Date();
	private String createAccount;
	private Date modifyTime = new Date();
	private String modifyAccount;
	private Boolean delFlag;
    //是否同步DDB
    private Boolean syncDdb;

    private Long installNum;
    private Long registerNum;
    //是够是debug模式 true 是测试,false不是测试
    private Boolean isDebug;

	private Boolean trackAndIoBothExhaust;
    private Boolean mainAccountExpire;



	public App() {
		super();
	}

	public App(String name, String platform, String appGenre, String gameGenre) {
		this.name = name;
		this.platform = platform;
		this.appGenre = appGenre;
		this.gameGenre = gameGenre;
	}

	public App(String name, String platform, String appGenre, String gameGenre,
			Long account) {
		this.name = name;
		this.platform = platform;
		this.appGenre = appGenre;
		this.gameGenre = gameGenre;
		this.account = account;
	}

	// public boolean isActive() {
	// return isActive;
	// }
	//
	// public void setActive(boolean isActive) {
	// this.isActive = isActive;
	// }
	public Long getAccount() {
		return account;
	}

	public String getAppGenre() {
		return appGenre;
	}

	@Transient
	public String getAppGenreName() {
		return appGenreName;
	}

	public void setAppGenreName(String appGenreName) {
		this.appGenreName = appGenreName;
	}

	public String getAppkey() {
		return appkey;
	}

	public String getGameGenre() {
		return gameGenre;
	}

/*	@Transient
	public String getGameCategory() {
		return gameCategory;
	}
	public void setGameCategory(String gameCategory) {
		this.gameCategory = gameCategory;
	}*/

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getPlatform() {
		return platform;
	}

	public String getUrl() {
		return url;
	}

	public boolean isSync() {
		return sync;
	}

	public void setAccount(Long account) {
		this.account = account;
	}

	public void setAppGenre(String appGenre) {
		this.appGenre = appGenre;
	}

	public void setAppkey(String appkey) {
		this.appkey = appkey;
	}

	public void setGameGenre(String gameGenre) {
		this.gameGenre = gameGenre;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public void setSync(boolean sync) {
		this.sync = sync;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Long getOrigiApp() {
		return origiApp;
	}

	public void setOrigiApp(Long origiApp) {
		this.origiApp = origiApp;
	}

	public String getBundleid() {
		return bundleid;
	}

	public void setBundleid(String bundleid) {
		this.bundleid = bundleid;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public boolean isRegedbutton() {
		return regedbutton;
	}

	public void setRegedbutton(boolean regedbutton) {
		this.regedbutton = regedbutton;
	}

	public String getInstalltoken() {
		return installtoken;
	}

	public void setInstalltoken(String installtoken) {
		this.installtoken = installtoken;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getCreateAccount() {
		return createAccount;
	}

	public void setCreateAccount(String createAccount) {
		this.createAccount = createAccount;
	}

	public Date getModifyTime() {
		return modifyTime;
	}

	public void setModifyTime(Date modifyTime) {
		this.modifyTime = modifyTime;
	}

	public String getModifyAccount() {
		return modifyAccount;
	}

	public void setModifyAccount(String modifyAccount) {
		this.modifyAccount = modifyAccount;
	}

	public Boolean getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Boolean delFlag) {
		this.delFlag = delFlag;
	}

    public Boolean getIsDebug() {
        return this.isDebug;
    }

    public void setIsDebug(Boolean isDebug) {
        this.isDebug = isDebug;
    }

    public Boolean getSyncDdb() {
        return syncDdb;
    }

    public void setSyncDdb(Boolean syncDdb) {
        this.syncDdb = syncDdb;
    }

	@Transient
	public Boolean getTrackAndIoBothExhaust() {
		return trackAndIoBothExhaust;
	}

	public void setTrackAndIoBothExhaust(Boolean trackAndIoBothExhaust) {
		this.trackAndIoBothExhaust = trackAndIoBothExhaust;
	}

	@Transient
	public Boolean getMainAccountExpire() {
		return mainAccountExpire;
	}

	public void setMainAccountExpire(Boolean mainAccountExpire) {
		this.mainAccountExpire = mainAccountExpire;
	}

	@Transient
    public Long getInstallNum() {
        return installNum;
    }

    public void setInstallNum(Long installNum) {
        this.installNum = installNum;
    }

    @Transient
    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    @Override
	public String toString() {
		return "App [id=" + id + ", name=" + name + ", platform=" + platform
				+ ", appGenre=" + appGenre + ", gameGenre=" + gameGenre
				+ ", appkey=" + appkey + ", url=" + url + ", account="
				+ account + ", sync=" + sync + ", origiApp=" + origiApp
				+ ", bundleid=" + bundleid + ", token=" + token
				+ ", installtoken=" + installtoken + ", regedbutton="
				+ regedbutton + ", createTime=" + createTime
				+ ", createAccount=" + createAccount + ", modifyTime="
				+ modifyTime + ", modifyAccount=" + modifyAccount
				+ ", delFlag=" + delFlag + "]";
	}

}
