package track.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Entity
public class App {

	private Long id;
	@NotNull
	private String name;
	private String platform;
	private String appGenre;
	private String gameGenre;
	private String appkey;
	private String url;
	private Long account;
	private boolean sync;
	private boolean isActive;
	private Long origiApp;
	private String bundleid;
	private String token;
	private String installtoken;
	private boolean regedbutton;


	private Date pubDate = new Date();

	public App() {
		super();
	}

	public App(String name, String platform, String appGenre, String gameGenre) {
		this.name = name;
		this.platform = platform;
		this.appGenre = appGenre;
		this.gameGenre = gameGenre;
	}

	public App(String name, String platform, String appGenre, String gameGenre,
			Long account) {
		this.name = name;
		this.platform = platform;
		this.appGenre = appGenre;
		this.gameGenre = gameGenre;
		this.account = account;
	}
	public boolean isActive() {
		return isActive;
	}

	public void setActive(boolean isActive) {
		this.isActive = isActive;
	}
	public Long getAccount() {
		return account;
	}

	public String getAppGenre() {
		return appGenre;
	}

	public String getAppkey() {
		return appkey;
	}

	public String getGameGenre() {
		return gameGenre;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getPlatform() {
		return platform;
	}

	public Date getPubDate() {
		return pubDate;
	}

	public String getUrl() {
		return url;
	}

	public boolean isSync() {
		return sync;
	}

	public void setAccount(Long account) {
		this.account = account;
	}

	public void setAppGenre(String appGenre) {
		this.appGenre = appGenre;
	}

	public void setAppkey(String appkey) {
		this.appkey = appkey;
	}

	public void setGameGenre(String gameGenre) {
		this.gameGenre = gameGenre;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}

	public void setSync(boolean sync) {
		this.sync = sync;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Long getOrigiApp() {
		return origiApp;
	}

	public void setOrigiApp(Long origiApp) {
		this.origiApp = origiApp;
	}

	public String getBundleid() {
		return bundleid;
	}

	public void setBundleid(String bundleid) {
		this.bundleid = bundleid;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public boolean isRegedbutton() {
		return regedbutton;
	}

	public void setRegedbutton(boolean regedbutton) {
		this.regedbutton = regedbutton;
	}

	public String getInstalltoken() {
		return installtoken;
	}

	public void setInstalltoken(String installtoken) {
		this.installtoken = installtoken;
	}

	@Override
	public String toString() {
		return "App{" +
				"id=" + id +
				", name='" + name + '\'' +
				", platform='" + platform + '\'' +
				", appGenre='" + appGenre + '\'' +
				", gameGenre='" + gameGenre + '\'' +
				", appkey='" + appkey + '\'' +
				", url='" + url + '\'' +
				", account=" + account +
				", sync=" + sync +
				", isActive=" + isActive +
				", origiApp=" + origiApp +
				", bundleid='" + bundleid + '\'' +
				", token='" + token + '\'' +
				", installtoken='" + installtoken + '\'' +
				", regedbutton=" + regedbutton +
				", pubDate=" + pubDate +
				'}';
	}
}
