package track.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import track.model.Account;
import track.model.App;

import java.math.BigInteger;
import java.util.List;

public interface TrackAppRepository extends JpaRepository<App, Long> {
	List<App> findByAccount(Long account);

	@Query(value = "select count(*) from app where account  in ?1 and pub_date >= ?2 and pub_date <= ?3", nativeQuery = true)
	BigInteger countByAccount(List<Long> accountId, String startDate, String endDate);

	@Query(value = "select * from app where account  in ?1 ", nativeQuery = true)
	List<App> findByAccount(List<Long> accountId);
}
