package track.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import track.model.Channel;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public interface TrackChannelRepository extends JpaRepository<Channel, Long> {
	List<Channel> findByAccount(Long account);

	@Query(value = "select count(*) from channel where account  in ?1 and pub_date > ?2 and pub_date < ?3", nativeQuery = true)
	BigInteger countByAccount(List<Long> accountId, String startDate, String endDate);
}
