package common.controller;

import common.model.Menu;
import common.model.User;
import common.service.MenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import security.annotation.CurrentAccount;
import util.ResultModel;

import java.util.List;

/**
 * Created by mxq on 17/12/21.
 * 优先测试账号查询
 */
@Controller
@RequestMapping("menu")
public class MenuController {

    @Autowired
    private MenuService menuService;


    @RequestMapping(value = "find", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAll(@CurrentAccount User loginAccount) {
        List<Menu> menus = menuService.listAll();
        return ResultModel.OK(menus);
    }
}
