package common.repository;

import common.model.Contract;
import common.model.ContractBody;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface ContractBodyRepository extends JpaRepository<ContractBody, Long> {

    @Query(value = "select * from contract_body where platform = ?1 ",nativeQuery = true)
    List<ContractBody> findByPlatform(String platform);

    @Query(value = "select distinct * from contract_body",nativeQuery = true)
    List<ContractBody> findAllDis();

    @Query(value = "select code from contract_body where id in ?1",nativeQuery = true)
    List<String> findByIds(List bodyids);

    @Query(value = "select * from contract_body group by code",nativeQuery = true)
    List<ContractBody> findAllCodeDis();
}
