package common.repository;

import common.model.BackVisit;
import common.model.PressMoney;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface PressMoneyRepository extends JpaRepository<PressMoney, Long> {

    @Query(value = "SELECT * from press_money where platform = ?1 and press_status is true", nativeQuery = true)
    List<PressMoney> findAllPress(String platform);

    @Query(value = "SELECT * from press_money where platform = ?1 and account_id = ?2 and press_status is true", nativeQuery = true)
    PressMoney findOnePress(String platform, Long account);

    @Query(value = "SELECT * from press_money where platform = ?1 and account_id = ?2", nativeQuery = true)
    PressMoney findOne(String platform, Long account);
}
