package common.service.impl;

import common.model.Account4Web;
import common.model.Contract;
import common.model.PackageBase;
import common.repository.ContractRepository;
import common.repository.PackageBaseRepository;
import common.service.AccountCommonService;
import office.model.BussinessMan;
import office.repository.BussinessManRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class AccountCommonServiceImpl implements AccountCommonService {


    @Autowired
    ContractRepository contractRepository;

    @Autowired
    BussinessManRepository bussinessManRepository;

    @Autowired
    PackageBaseRepository packageBaseRepository;

    @Override
    public Account4Web findOne(String platgorm, String email) {

        List<Contract> contract = contractRepository.findByPlatformAndEmailStatus(platgorm, email);
        Account4Web account4Web = new Account4Web();
        Contract thecontract = contract.get(0);

        account4Web.setEmail(thecontract.getEmail());
        account4Web.setAccountId(0L);
        account4Web.setId(0L);

        PackageBase packageBase = packageBaseRepository.findOne(thecontract.getPriceLevel());
        account4Web.setPackageType(packageBase.getPackageName());

        BussinessMan bussinessMan = bussinessManRepository.findOne(thecontract.getSale());
        account4Web.setSaleName(bussinessMan.getName());

        return account4Web;
    }
}
