package tkio.task;

import common.model.Account4Web;
import common.model.Notice;
import common.model.User;
import common.repository.Account4WebRepository;
import common.repository.NoticeRepository;
import common.repository.UserRepository;
import dic.RoleEnum;
import org.springframework.beans.factory.annotation.Autowired;
import tkio.model.SalesManLeader;
import tkio.repository.SalesManLeaderRepository;
import util.DateUtil;
import util.ValidateUtil;

import java.util.*;

/**
 * Created by mxq on 2017/12/27.
 */
public class NoticeTask {
    @Autowired
    Account4WebRepository account4WebRepository;

    @Autowired
    UserRepository userRepository;
    @Autowired
    SalesManLeaderRepository salesManLeaderRepository;
    @Autowired
    NoticeRepository noticeRepository;

    public void task(){
        System.out.println("同步消息任务开始");
        noticeRepository.findAll();
        List<Account4Web> account4WebList = account4WebRepository.findByPast(DateUtil.getBeforeDays(1));
        Map<Long, Integer> map = new HashMap<>();
        Map<Long, Integer> mapTotle = new HashMap<>();
        if(ValidateUtil.isValid(account4WebList)){
            for(Account4Web aw : account4WebList){
                if(mapTotle.containsKey(0L)){
                    mapTotle.put(0L, mapTotle.get(0L) + 1);
                }else{
                    mapTotle.put(0L, 1);
                }

                if(null != aw.getBussinessMan()){
                    if(map.containsKey(aw.getBussinessMan())){
                        map.put(aw.getBussinessMan(), map.get(aw.getBussinessMan()) + 1);
                    }else{
                        map.put(aw.getBussinessMan(), 1);
                    }
                }
            }
            List<SalesManLeader> salesManLeaders = salesManLeaderRepository.findAll();
            Map<String, List<Long>> saleMap = new HashMap<>();
            if(ValidateUtil.isValid(salesManLeaders)){
                for(SalesManLeader sml : salesManLeaders){
                    List<Long> idList = new ArrayList<>();
                    if(sml.getId() == 0 || sml.getId() == sml.getLeader()){//不是主管
                        Long id = (long)sml.getId();
                        idList.add(id);
                    }else{//是主管
                        for(SalesManLeader sml2 : salesManLeaders){
                            if(sml.getId() == sml2.getLeader()){
                                Long id = (long)sml.getId();
                                idList.add(id);
                            }
                        }
                    }
                    saleMap.put(sml.getEmail(), idList);
                }
            }

            Map<Long, Integer> resultMap = new HashMap<>();
            List<User> userList = userRepository.findAll();
            if(mapTotle.containsKey(0L)){
                for(User user : userList){
                    if(user.getRole().equals(RoleEnum.MANAGER.getKey())){
                        resultMap.put(user.getId(), mapTotle.get(0L));
                    } else{
                        if(saleMap.containsKey(user.getId())){
                            List<Long> list = saleMap.get(user.getId());
                            for(Long id : list){
                                if(map.containsKey(id)){
                                    if(resultMap.containsKey(user.getId())){
                                        resultMap.put(user.getId(), map.get(user.getId()) + map.get(id));
                                    }else{
                                        resultMap.put(user.getId(), map.get(id));
                                    }
                                }
                            }
                        }
                    }
                }

                List<Notice> list = new ArrayList<>();
                String today = DateUtil.getBeforeDays(0);
                Set<Long> keySet = resultMap.keySet();
                for(Long id : keySet){
                    int num = resultMap.get(id);
                    Notice notice = new Notice();
                    notice.setUser(id);
                    notice.setPlatform("tkio");
                    notice.setContent("今日tkio有" + num + "个客户过期,请及时联系客户");
                    notice.setDs(today);
                    notice.setNotRead(true);
                    list.add(notice);
                }
                noticeRepository.save(list);
            }
        }

        System.out.println("同步消息任务结束");
    }
}
