package userio.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import userio.model.Account;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@Transactional
public interface IOAccountRepository extends JpaRepository<Account, Long> {
    @Query(value = "select root_parent from account where id=?1", nativeQuery = true)
    BigInteger findRootParentByAccountId(Long accountId);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and past_date > ?1", nativeQuery = true)
    List<Account> findRootParentsUnPast(String today);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and past_date < ?1", nativeQuery = true)
    List<Account> findRootParentsPast(String today);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and DATE_FORMAT(pub_date,'%Y-%m-%d') = ?1", nativeQuery = true)
    List<Account> findRootParentsByPubDate(String date);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 0", nativeQuery = true)
    List<Account> findRootParentsForidin();

    @Query(value = "SELECT * from account where is_super_user is true and  bussinessman in ?1", nativeQuery = true)
    List<Account> findBussnissMan(List<Integer> bussinussIds);

    @Query(value = "select * from account where root_parent = ?1", nativeQuery = true)
    List<Account> findByRootParent(Long accountId);

    @Query(value = "select count(*) from account where root_parent = ?1 and create_time > ?2 and create_time < ?3", nativeQuery = true)
    BigInteger countByRootParent(Long accountId, String startDate, String endDate);

    @Query(value = "select * from account where email = ?1", nativeQuery = true)
    Account findByEmail(String email);
}
