package common.controller;

import common.model.User;
import common.model.UserLog;
import common.service.ContractService;
import common.service.UserLogService;
import dic.AuthMenuEnmm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.AuthKey;
import security.annotation.CurrentAccount;
import util.ResultModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by zxy on 2017/12/27.
 */
@Controller
@RequestMapping(value = "system/userlog")
public class UserLogController
{
    @Autowired UserLogService userLogService;

    @Autowired
    private ContractService service;

    ///api/userlog/list?startDate=2017-12-26&endDate=2017-12-27
    @RequestMapping(value = "list", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findByDS(@CurrentAccount User user, @RequestParam String startDate, @RequestParam String endDate) {
        return ResultModel.OK(userLogService.findUserLog(user,startDate, endDate));
    }



    @RequestMapping(value = "change/del/info", method = RequestMethod.GET)
    @ResponseBody
    @AuthKey(AuthMenuEnmm.USERLOGS_V)
    public ResultModel getChangeDelData( @CurrentAccount User loginAccount,
                                        HttpServletRequest request,
                                        String contranctCode,String startDate,String  endDate) {

        return ResultModel.OK(service.getChangeDelData(loginAccount,contranctCode,startDate,endDate));
    }

    @RequestMapping(value = "change/del/detail", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel getChangeDelDetail( @CurrentAccount User loginAccount,
                                           String pid) {

        return ResultModel.OK(service.getChangeDelDetailData(loginAccount,pid));
    }

    @RequestMapping(value = "change/del/recover", method = RequestMethod.GET)
    @ResponseBody
    @AuthKey(AuthMenuEnmm.USERLOGS_RE)
    public ResultModel changesDelRecover( @CurrentAccount User loginAccount,
                                          HttpServletRequest request,String id,String type) {

        return ResultModel.OK(service.changesDelRecover(id,type,loginAccount));

    }
}
