package common.repository;

import common.model.PackageBase;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Transactional
public interface PackageBaseRepository extends JpaRepository<PackageBase, Long> {

    @Query(value = "select * from package_base where platform =?1 and status =?2",nativeQuery = true)
    List<PackageBase> findByPlatAndStatus(String platform, int status);


}
