package tkio.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tkio.model.SalesManLeader;
import tkio.repository.SalesManLeaderRepository;
import tkio.service.SalesManService;
import tkio.service.SendEmailService;
import util.MailUtils;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mxq on 2018/1/2.
 */
@Service
public class SendEmailServiceImpl implements SendEmailService {

    @Override
    public void send(String email, List<String> content) {
        String contentStr = String.join(",", content);
        StringBuffer sb = new StringBuffer();
        if(ValidateUtil.isValid(content)){
            for(String e : content){
                sb.append(e).append("\r\n");
            }
            List<String> list = new ArrayList<>();
            list.add(email);
            try {
                MailUtils.sendSimpleEmail("账号过期提醒", "以下账号过期了,请及时处理  : " + sb.toString(),list);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }
}
