package adi.controller;


import adi.model.ADIUser;
import adi.service.ADIAccountService;
import common.model.*;
import common.service.AccountCommonService;
import dic.OperateObjectTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import userio.service.IOAccountService;
import util.ResultModel;
import util.ResultStatus;
import util.UserLogThread;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by mxq on 2017/12/21.
 */
@Controller
@RequestMapping("adi/marketing/accountmng")
public class ADIAccountController {

    @Autowired
    ADIAccountService tkioAccountService;

    @Autowired
    AccountCommonService accountCommonService;
    //sale
    @RequestMapping(value = "/findSale", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findSale(@CurrentAccount User loginAccount, @RequestParam(required = false) Long sale) {

        return ResultModel.OK(tkioAccountService.findSale(loginAccount, sale));
    }

    //sale
    @RequestMapping(value = "/findSaleInfo", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findSale( @RequestParam String email) {
        return ResultModel.OK(tkioAccountService.findSale(email));
    }

    //sale
    @RequestMapping(value = "/update/sale", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updateSale(@CurrentAccount User loginAccount,
                                  @RequestParam String email, @RequestParam String accountEmail, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), accountEmail, "tkio修改销售为 " + email, request,loginAccount.getRole(), "adi");
        userlog.start();
        return ResultModel.OK(tkioAccountService.updateSale(email, accountEmail));
    }


    //客户列表
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel find(@CurrentAccount User loginAccount) {
        return ResultModel.OK(tkioAccountService.findAll(loginAccount));
    }

    @RequestMapping(value = "/findone", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOne(@CurrentAccount User loginAccount, @RequestParam String email) {
//        ADIUser account4Web = tkioAccountService.findOne(email);
//        if(null == account4Web){
//            return ResultModel.ERROR(ResultStatus.USER_EMPTY);
//        }
        return ResultModel.OK(accountCommonService.findOne("adi",email));
    }
    @RequestMapping(value = "/find/reminderlevel", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findReminderlevel() {
        return ResultModel.OK(tkioAccountService.findReminderlevel());
    }




    //关闭缴费提醒
    @RequestMapping(value = "/forbidenpress", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbidenPress(@CurrentAccount User loginAccount, @RequestBody PressMoney resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "关闭异常状态跟进", request,loginAccount.getRole(), "adi");
        userlog.start();
        return ResultModel.OK(tkioAccountService.forbidenPress(loginAccount, resource));
    }

    //开启缴费提醒
    @RequestMapping(value = "/enablepress", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enablePress(@CurrentAccount User loginAccount, @RequestBody PressMoney resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "开启异常状态跟进", request,loginAccount.getRole(), "adi");
        userlog.start();
        return ResultModel.OK(tkioAccountService.enablePress(loginAccount, resource));
    }



    //回访
    @RequestMapping(value = "/visit", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel visit(@CurrentAccount User loginAccount, @RequestBody BackVisit resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "回访", request,loginAccount.getRole(), "adi");
        userlog.start();
        return ResultModel.OK( tkioAccountService.visit(loginAccount, resource));
    }


    //回访查询
    @RequestMapping(value = "/find/visit/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findVisit(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findVisit(accountId,startDate,endDate));
    }

    //缴费查询
    @RequestMapping(value = "/find/pay/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findPay(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @RequestParam String email,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findPay(email,startDate,endDate));
    }


    //合同查询
    @RequestMapping(value = "/find/contract/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findContract(@CurrentAccount User loginAccount, @RequestParam(required =false) String startDate,
                                  @RequestParam(required =false) String endDate,  @RequestParam String email) {

        return ResultModel.OK(tkioAccountService.findContractChange(email,startDate,endDate));
    }


    @RequestMapping(value = "/find/function/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findFunction(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                    @RequestParam String endDate, @PathVariable Long accountId) {

        //返回默认数据
        Map result = new HashMap();
        result.put("numAccount", 0);
        result.put("numApp", 0);
        result.put("numCampaign", 0);
        result.put("numChannel", 0);
        result.put("event_sum", 0);
        result.put("click_sum", 0);
        return ResultModel.OK(result);
    }


}
