package common.controller;


import common.model.User;
import common.repository.UserRepository;
import common.service.NoticeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.RedisLoginStatusManager;
import security.TokenManager;
import security.annotation.CurrentAccount;
import util.CipherUtil;
import util.Constant;
import util.ResultModel;
import util.ValidateUtil;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;


@Controller
@RequestMapping("notice")
public class NoticeController {

    protected Logger logger = LoggerFactory.getLogger(NoticeController.class);

    @Autowired
    NoticeService noticeService;


    @RequestMapping(value = "find", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel find(@CurrentAccount User user) {
        return ResultModel.OK(noticeService.findAll(user));
        }

    @RequestMapping(value = "read", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel loginCheck(@CurrentAccount User user) {
        return ResultModel.OK(noticeService.read(user));
    }

}
