package common.repository;

import common.model.BarrioCity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface BarrioCityRepository extends JpaRepository<BarrioCity, Long> {

    @Query(value = "select * from barrio_city where parent_id = ?1",nativeQuery = true)
    List<BarrioCity> findByParentId(long parentId);
}
