package common.repository;

import common.model.Contract;
import common.model.PriceLevelMoney;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface PriceLevelMoneyRepository extends JpaRepository<PriceLevelMoney, Long> {

    @Query(value="select * from price_level_money where product = ?1 and pricelevel = ?2",nativeQuery=true)
    PriceLevelMoney getOne(String product, Integer level);

}
