package common.service;

import common.model.*;
import org.springframework.web.multipart.MultipartFile;
import util.ResultModel;

import java.util.List;
import java.util.Map;

/**
 * Created by mxq on 2018/1/16.
 */
public interface ContractService {

    Map<String, Object> checkAccount(String email, String platfrom);

    Boolean checkTime(String email, String platfrom, String type, String product);

    List<ContractBody> findBody(String platform, User loginAccount);

    String getContractCode(String code);

    List findSetmeal(String platform);
    //增值服务
    List<ContractIncrement> findIncrement();

    Double getRebat(String product, Integer level, Double money);

    List<Sales> getSales();

    Contract create(User loginUser, Contract resource);

    Contract update(User loginUser, Contract resource, String ip);

    List<Contract> findAll(User loginAccount,String startDate, String endDate, String platfrom,String contractId);

    Contract findOne(String code);

    ContractMoney pay(User loginUser, ContractMoney resource);

    Contract change(User loginUser, ContractChange resource, FlowChange flowChange);

    List<ContractMoney> findPay(String startDate, String endDate, String code);

    List<ContractChange> findChange(String startDate, String endDate, String code);

    Contract updatePay(User loginUser, ContractMoney resource, String ip);


    Contract build(Contract contract);

    String getContractCode(String code, String platform, String company);

    List<TradeType> getTradeData(String platform);

    List<Map> contractCodeAll(String platform, String contractId);

//    List<Contract> findAllContract(User loginAccount, String startDate, String endDate, String platform, String contractId);

    Contract contractStatusUpdate(String platform, String contractId, String status, String ip, User loginUser);

    Map contractCodeCheck(String platform, String contractCode);

    List<FlowChange> findflowChange(String startDate, String endDate, String code);

    Object changesDel(String platform, String id, String type, String ip, User loginAccount);

    List<ChangeDelInfo> getChangeDelData(User loginAccount, String contranctCode, String startDate, String endDate);

    List<ChangeDelDetail> getChangeDelDetailData(User loginAccount, String pid);

    ChangeDelInfo changesDelRecover(String id, String type, User loginAccount);

    Contract findOne(User loginAccount, String startDate, String endDate, String platform, String contractId);

    List<ContractMoney> findPayAll(User loginAccount,String startDate, String endDate, String platform, String moneyType, String packageType, String money_ids);

    ResultModel uploadBatchInfo(MultipartFile file, String platform);

    Object getBarrioCities();
}