package common.service.impl;

import common.model.Notice;
import common.model.User;
import common.repository.NoticeRepository;
import common.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mxq on 2017/12/28.
 */
@Service
public class NoticeServiceImpl implements NoticeService {

    @Autowired
    NoticeRepository noticeRepository;


    @Override
    public List<Notice> findAll(User user) {
        List<Notice> noticeList = noticeRepository.findall(user.getId(), DateUtil.getBeforeDays(7));
        return noticeList;
    }

    @Override
    public Boolean read(User user) {
        List<Notice> noticeList = noticeRepository.findall(user.getId());
        if(ValidateUtil.isValid(noticeList)){
            List<Notice> notices = new ArrayList<>();
            for (Notice n : noticeList){
                n.setNotRead(false);
                notices.add(n);
            }
            noticeRepository.save(notices);
        }

        return true;
    }
}
