package dmp.controller;


import common.model.Account4Web;
import common.model.User;
import common.service.AccountCommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import util.ResultModel;
import util.ResultStatus;

import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("dmp/marketing/accountmng")
public class DmpAccountController {



    @Autowired
    AccountCommonService accountCommonService;


    //功能使用查询
    @RequestMapping(value = "/find/function/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findFunction(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                    @RequestParam String endDate, @PathVariable Long accountId) {

        //返回默认数据
        Map result = new HashMap();
        result.put("numAccount", 0);
        result.put("numApp", 0);
        result.put("numCampaign", 0);
        result.put("numChannel", 0);
        result.put("event_sum", 0);
        result.put("click_sum", 0);
        return ResultModel.OK(result);
    }


    @RequestMapping(value = "/findone", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOne(@CurrentAccount User loginAccount, @RequestParam String email) {

        return ResultModel.OK(accountCommonService.findOne("dmp",email));
    }
}
