package tkio.model;


import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

@Entity
public class Channel {

	private Long id;
	private String name;
	private String category;
	private Long account;
	private String url;
	private String type;
	private String uniqueName;
	private String firstchar;
	private boolean ishttps=false;
    private Boolean osAndroid;
    private Boolean osIos;
    private Boolean osWeb;
	private String trackurl;
	private String androidparam;
	private String iosparam;
	private boolean istrackurlspecial=false;
	
	private Date createTime;
    private Long createAccount;
    private Date modifyTime;
    private Long modifyAccount;
    private Boolean delFlag;
    
    private String specialParams;
    private String nodeUrl;

	public String getNodeUrl() {
		return nodeUrl;
	}

	public void setNodeUrl(String nodeUrl) {
		this.nodeUrl = nodeUrl;
	}

	private boolean isintegrate = false;

	private Integer iscostrecovery;  //0：没对接，1：API，2：爬虫。

	private Integer orderindex;

	//0 正常渠道  1 被合并渠道，不再显示
	private Boolean isNotShow;
	//0 正常渠道  1 未覆盖中国，不再显示 例如：Search Ads
	private Boolean isNotCover;

	public Channel() {
		super();
	}

	public Channel(String name, String category, String url) {
		super();
		this.name = name;
		this.category = category;
		this.url = url;

	}

    public Channel(Long channelId, String name){
        super();
        this.id = channelId;
        this.name = name;
    }

	public String getCategory() {
		return category;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getUrl() {
		return url;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getUniqueName() {
		return uniqueName;
	}

	public void setUniqueName(String uniqueName) {
		this.uniqueName = uniqueName;
	}

	public String getFirstchar() {
		return firstchar;
	}

	public void setFirstchar(String firstchar) {
		this.firstchar = firstchar;
	}

	public boolean isIshttps() {
		return ishttps;
	}

	public void setIshttps(boolean ishttps) {
		this.ishttps = ishttps;
	}

    public Boolean getOsAndroid() {
        return osAndroid;
    }

    public void setOsAndroid(Boolean osAndroid) {
        this.osAndroid = osAndroid;
    }

    public Boolean getOsIos() {
        return osIos;
    }

    public void setOsIos(Boolean osIos) {
        this.osIos = osIos;
    }

    public Boolean getOsWeb() {
        return osWeb;
    }

    public void setOsWeb(Boolean osWeb) {
        this.osWeb = osWeb;
    }

    public String getTrackurl() {
		return trackurl;
	}

	public void setTrackurl(String trackurl) {
		this.trackurl = trackurl;
	}
	

	public String getAndroidparam() {
		return androidparam;
	}

	public void setAndroidparam(String androidparam) {
		this.androidparam = androidparam;
	}

	public String getIosparam() {
		return iosparam;
	}

	public void setIosparam(String iosparam) {
		this.iosparam = iosparam;
	}

	public boolean isIstrackurlspecial() {
		return istrackurlspecial;
	}

	public void setIstrackurlspecial(boolean istrackurlspecial) {
		this.istrackurlspecial = istrackurlspecial;
	}

	public boolean isIsintegrate() {
		return isintegrate;
	}

	public void setIsintegrate(boolean isintegrate) {
		this.isintegrate = isintegrate;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getModifyTime() {
		return modifyTime;
	}

	public void setModifyTime(Date modifyTime) {
		this.modifyTime = modifyTime;
	}

	public Boolean getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Boolean delFlag) {
		this.delFlag = delFlag;
	}

	public Long getCreateAccount() {
		return createAccount;
	}

	public void setCreateAccount(Long createAccount) {
		this.createAccount = createAccount;
	}

	public Long getModifyAccount() {
		return modifyAccount;
	}

	public void setModifyAccount(Long modifyAccount) {
		this.modifyAccount = modifyAccount;
	}

	public Long getAccount() {
		return account;
	}

	public void setAccount(Long account) {
		this.account = account;
	}

	public String getSpecialParams() {
		return specialParams;
	}

	public void setSpecialParams(String specialParams) {
		this.specialParams = specialParams;
	}

	public Integer getIscostrecovery() {
		return iscostrecovery;
	}

	public void setIscostrecovery(Integer iscostrecovery) {
		this.iscostrecovery = iscostrecovery;
	}

	public Integer getOrderindex()
	{
		return orderindex;
	}

	public void setOrderindex(Integer orderindex)
	{
		this.orderindex = orderindex;
	}

	public Boolean getNotShow() {
		return isNotShow;
	}

	public void setNotShow(Boolean notShow) {
		isNotShow = notShow;
	}

	public Boolean getNotCover() {
		return isNotCover;
	}

	public void setNotCover(Boolean notCover) {
		isNotCover = notCover;
	}
}
