package tkio.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import tkio.model.Account;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Transactional
public interface AccountRepository extends JpaRepository<Account, Long> {

    @Query(value = "select root_parent from account where id=?1", nativeQuery = true)
    BigInteger findRootParentByAccountId(Long accountId);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and DATE_FORMAT(pub_date,'%Y-%m-%d') = ?1", nativeQuery = true)
    List<Account> findRootParentsByPubDate(String date);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and past_date > ?1", nativeQuery = true)
    List<Account> findRootParentsUnPast(String today);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 1 and past_date < ?1", nativeQuery = true)
    List<Account> findRootParentsPast(String today);

    @Query(value = "SELECT * from account where is_super_user is true and `status` = 0", nativeQuery = true)
    List<Account> findRootParentsForbiden();

    @Query(value = "SELECT * from account where is_super_user is true and  bussinessman in ?1", nativeQuery = true)
    List<Account> findBussnissMan(List<Integer> bussinussIds);

    @Query(value = "select * from account where root_parent = ?1", nativeQuery = true)
    List<Account> findByRootParent(Long accountId);

    @Query(value = "select count(*) from account where root_parent = ?1 and create_time > ?2 and create_time < ?3", nativeQuery = true)
    BigInteger countByRootParent(Long accountId, String startDate, String endDate);

    @Query(value = "select * from account where email = ?1", nativeQuery = true)
    Account findByEmail(String email);

    @Query(value = "select email from account where is_super_user is true and  email in ?1", nativeQuery = true)
    List<String> findEmailByEmails(List<String> accountsEmail);

    @Query(value = "" +
            "select xy.email,IF(group_concat(xy.appkey separator ',') is not NULL,group_concat(xy.appkey separator ','),'') as appkey  " +
            "from(" +
            "  select x.appkey,y.pid,y.email,y.id" +
            "  from(" +
            "    select DISTINCT a.id pid,a.email,b.id" +
            "    from(select id,email from account where id = root_parent and role_category <> 5 and email not in (select distinct email from manager.contract where platform='tkio'))a " +
            "    join(select id,root_parent from account)b on a.id=b.root_parent " +
            "  )y " +
            "  left join app x " +
            "  on x.account=y.id " +
            ")xy " +
            "group by xy.pid,xy.email", nativeQuery = true)
    List<Map<String,String>> findAllAccountAppKeys();

    @Query(value = "" +
            "select xy.email,IF(group_concat(xy.appkey separator ',') is not NULL,group_concat(xy.appkey separator ','),'') as appkey  " +
            "from(" +
            "  select x.appkey,y.pid,y.email,y.id" +
            "  from(" +
            "    select DISTINCT a.id pid,a.email,b.id" +
            "    from(select id,email from account where id = root_parent and role_category <> 5 and email not in (select distinct email from manager.contract where platform='tkio')and email=?1)a " +
            "    join(select id,root_parent from account)b on a.id=b.root_parent " +
            "  )y " +
            "  left join app x " +
            "  on x.account=y.id " +
            ")xy " +
            "group by xy.pid,xy.email", nativeQuery = true)
    List<Map<String, String>> findAccountAppKeysByEmail(String email);
    
}
