package tkio.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import tkio.model.Campaign;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface CampaignRepository extends JpaRepository<Campaign, Long> {

    Iterable<Campaign> findByApp(Long id);

    @Query(value = "select count(*) from campaign where account  in ?1 and create_time > ?2 and create_time < ?3", nativeQuery = true)
    BigInteger countByAccount(List<Long> accountId, String startDate, String endDate);
}
