package track.controller;

import common.model.*;
import dic.OperateObjectTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import track.service.TrackAccountService;
import util.ResultModel;
import util.ResultStatus;
import util.UserLogThread;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by mxq on 2017/12/21.
 */
@Controller
public class AdsAccountController {

    @Autowired
    TrackAccountService tkioAccountService;

    //客户列表
    @RequestMapping(value = "/ads/marketing/accountmng/findAll", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAds(@CurrentAccount User loginAccount) {
        return ResultModel.OK(tkioAccountService.findAllAds(loginAccount));
    }

    @RequestMapping(value = "/abtest/marketing/accountmng/findAll", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAbTest(@CurrentAccount User loginAccount) {
        return ResultModel.OK(tkioAccountService.findAllAbTest(loginAccount));
    }


}
