package track.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import track.model.Account;
import track.model.App;
import track.repository.MeasureRepository;
import track.repository.TrackAppRepository;
import track.service.TrackAccountFlowRestrictService;
import util.DateUtil;
import util.ValidateUtil;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by song on 2017/10/19.
 */
@Service
public class TrackAccountFlowRestrictServiceImpl implements TrackAccountFlowRestrictService {

    @Autowired
    TrackAppRepository trackAppRepository;
    @Autowired
    MeasureRepository measureRepository;

    @Override
    public BigInteger findRestrictByAccount(Account account) {
       BigInteger re =  new BigInteger("0");
        List<App> apps = trackAppRepository.findByAccount(account.getId());

        StringBuffer appsStr = new StringBuffer();
        if(ValidateUtil.isValid(apps)){
            List<String> appids = new ArrayList<>();
            for (App app : apps) {
                appids.add(app.getAppkey());
            }
            String startDate = DateUtil.format(account.getPubDate());
            String endDate = DateUtil.getBeforeDays(0);
            Double click = measureRepository.findByApp(appids, endDate, startDate);
            return null == click ? re : new BigInteger(click.intValue() + "");
        }

        return re;
    }


}
