package common.controller;

import common.model.User;
import common.model.UserLog;
import common.service.UserLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import security.annotation.CurrentAccount;
import util.ResultModel;

import java.util.List;

/**
 * Created by zxy on 2017/12/27.
 */
@Controller
@RequestMapping(value = "system/userlog")
public class UserLogController
{
    @Autowired UserLogService userLogService;

    ///api/userlog/list?startDate=2017-12-26&endDate=2017-12-27
    @RequestMapping(value = "list", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findByDS(@CurrentAccount User user, @RequestParam String startDate, @RequestParam String endDate) {
        return ResultModel.OK(userLogService.findUserLog(user,startDate, endDate));
    }
}
