package common.repository;

import common.model.Auth;
import common.model.Code;
import common.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Transactional
public interface CodeRepository extends JpaRepository<Code, Long> {

    @Query(value="select * from code where email = ?1 and create_time > ?2 group by id desc limit 1",nativeQuery=true)
    Code findValid(String email, Date date);
}
