package common.repository;

import common.model.Contract;
import common.model.ContractChange;
import common.model.ContractMoney;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface ContractMoneyRepository extends JpaRepository<ContractMoney, Long> {

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2 and contract_code = ?3  order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDs(String startDate, String endDate, String code);

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2  and platform = ?3 order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDsAll(String startDate, String endDate, String platform);

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2 and email = ?3 and platform = ?4 order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDs(String startDate, String endDate, String email, String platform);

    @Query(value="select * from contract_money where email = ?1 and platform = ?2 and type = 'pay' order by ds desc",nativeQuery=true)
    List<ContractMoney> findByEmail(String email, String platform);
}
