package common.task;

import com.google.common.base.Splitter;
import common.model.AppCategory;
import common.model.AppInfo;
import common.model.Contract;
import common.repository.AppCategoryRepository;
import common.repository.AppInfoRepository;
import common.repository.CityRepository;
import common.repository.ContractRepository;
import dmp.model.OtPkgDevStats;
import dmp.repository.OtPkgDevStatsRepository;
import dmp.repository.TagCrawlerAppsWandoujiaRepository;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.LzoInputStream;
import org.anarres.lzo.LzoLibrary;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import util.*;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zxy on 2017/12/26.
 */
public class ContractTask
{
    private static Logger logger = LoggerFactory.getLogger(ContractTask.class);
    @Autowired
    ContractRepository contractRepository;

    public void task(){
        List<Contract> contractList = contractRepository.findByStartDate(DateUtil.getBeforeDays(0));
        if(ValidateUtil.isValid(contractList)){
            List<Contract> list = new ArrayList<>();
            for(Contract c : contractList){
                c.setStatus("executing");
                list.add(c);
            }
            contractRepository.save(list);
        }

        List<Contract> contractList2 = contractRepository.findByEndDate(DateUtil.getBeforeDays(0));
        if(ValidateUtil.isValid(contractList2)){
            List<Contract> list = new ArrayList<>();
            for(Contract c : contractList2){
                c.setStatus("end");
                list.add(c);
            }
            contractRepository.save(list);
        }
    }


}
