package tkio.task;

import common.controller.ContractController;
import common.model.Contract;
import common.repository.ContractRepository;
import dic.ContractTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tkio.model.Account;
import tkio.repository.AccountRepository;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mxq on 2018/4/23.
 */
public class AccountCheck {
    private static final Logger logger = LoggerFactory.getLogger(AccountCheck.class);
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    ContractRepository contractRepository;

    public void task(){
        List<Account> accountList = accountRepository.findRootParentsByPubDate(DateUtil.getBeforeDays(30));
        logger.error("startDate :" + DateUtil.getBeforeDays(30));
        logger.error("startDate :" + accountList);
        if(ValidateUtil.isValid(accountList)){
            List<Account> list = new ArrayList<>();
            for(Account a: accountList){
                List<Contract> contractList = contractRepository.findByPlatformAndEmail("tkio", a.getEmail(), ContractTypeEnum.MAIN.getKey());
                logger.error("startDate :" + (null == contractList));
                if(null == contractList || contractList.isEmpty()){
                    a.setStatus(0);
                    list.add(a);
                }

                if(ValidateUtil.isValid(list)){
                    accountRepository.save(list);
                }
            }


        }
    }
}
