package tkio.task;

import common.model.Account4Web;
import common.repository.Account4WebRepository;
import common.task.SyncAppDataTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tkio.model.Account;
import tkio.model.AccountRestrict4Web;
import tkio.model.PackageType;
import tkio.model.SalesManLeader;
import tkio.repository.AccountRepository;
import tkio.repository.PackageTypeRepository;
import tkio.repository.SalesManLeaderRepository;
import tkio.service.AccountFlowRestrictService;
import util.DateUtil;
import util.ValidateUtil;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mxq on 2017/12/25.
 */
public class AccountTask {
    private static Logger logger = LoggerFactory.getLogger(AccountTask.class);

    @Autowired
    AccountRepository accountRepository;

    @Autowired
    Account4WebRepository account4WebRepository;

    @Autowired
    AccountFlowRestrictService accountFlowRestrictService;

    @Autowired
    private PackageTypeRepository packageTypeRepository;

    @Autowired
    SalesManLeaderRepository salesManLeaderRepository;

    public void task(){
        logger.info("tkio task start :" + System.currentTimeMillis());
        List<SalesManLeader> SalesManLeader = salesManLeaderRepository.findAll();
        Map<Long, String> saleMap = new HashMap<>();
        for(SalesManLeader pt : SalesManLeader){
            saleMap.put((long)pt.getId(), pt.getEmail());
        }
        List<PackageType> packageTypeList = packageTypeRepository.findAll();
        Map<Long, String> map = new HashMap<>();
        for(PackageType pt : packageTypeList){
            map.put(pt.getId(), pt.getPackageName());
        }
        //清空前一天数据
        account4WebRepository.deleteAll();
        List<Account4Web> list = new ArrayList<>();
        //未过期的查询是否流量到期
        List<Account> accountValidList = accountRepository.findRootParentsUnPast(DateUtil.getBeforeDays(1));
        if(ValidateUtil.isValid(accountValidList)){
            for(Account ac : accountValidList){
                Account4Web account4Web = new Account4Web();
                account4Web.setAccountId(ac.getId());
                account4Web.setPackageTypeId(ac.getPricelevel());
                account4Web.setEmail(ac.getEmail());
                account4Web.setCompany(ac.getCompany());
                account4Web.setCreateDate(ac.getPubDate());
                account4Web.setCreateDs(DateUtil.getFormatDate(ac.getPubDate()));
                account4Web.setPastDate(ac.getPastDate());
                account4Web.setUser(ac.getName());
                account4Web.setTell(ac.getPhone());
                account4Web.setBussinessMan(ac.getBussinessman());
                if(saleMap.containsKey(ac.getBussinessman())){
                    account4Web.setSaleEamil(saleMap.get(ac.getBussinessman()));
                }
                try{
                    AccountRestrict4Web restrict4Web = accountFlowRestrictService.findRestrictByAccount(ac.getId());
                    account4Web.setStatus(null == restrict4Web.getIOFlowNotified() ? "已激活" : (restrict4Web.getIOFlowNotified() ? "已激活" : "流量用尽"));
                    account4Web.setPackageType(restrict4Web.getPackageName());
                    if (ac.getPricelevel().equals(7L) || ac.getPricelevel().equals(8L) || ac.getPricelevel().equals(5L) || ac.getPricelevel().equals(6L)){
                        account4Web.setIo(restrict4Web.getThisMonthIOFlow());
                        account4Web.setTrack(restrict4Web.getTrackTotalFlow());
                    }else{
                        account4Web.setIo(restrict4Web.getThisMonthIOFlow());
                        account4Web.setTrack(restrict4Web.getTrackTotalFlow());
                        account4Web.setIoLimit(restrict4Web.getIOLimit());
                        account4Web.setTrackLimit(restrict4Web.getTrackLimit());
                        account4Web.setIoStatus(restrict4Web.getAllowBehavior());
                        account4Web.setTrackStatus(restrict4Web.getTrackFlowNotified());
//                        double f = 1.0;
//                        if((account4Web.getIo().doubleValue() != 0) && (null != account4Web.getIoLimit())){
//                            if(account4Web.getIo().doubleValue() > account4Web.getIoLimit().doubleValue()){
//                                account4Web.setIoStatus(false);
//                                account4Web.setStatus("流量用尽");
//                            }else{
//                                account4Web.setIoStatus(true);
//                            }
//                        }else {
//                            account4Web.setIoStatus(true);
//                        }
//                        if(account4Web.getIoLimit().doubleValue() == -1){
//                            account4Web.setIoStatus(true);
//                            account4Web.setStatus("已激活");
//
//                        }
                        if(account4Web.getTrackLimit().doubleValue() <= 0){
                            account4Web.setTrackStatus(true);
                            account4Web.setStatus("已激活");

                        }
                        if(account4Web.getTrackStatus()){
                            account4Web.setStatus("已激活");
                        }
                    }
                    list.add(account4Web);
                } catch (Exception e){
                    account4Web.setPackageType(map.get(ac.getPricelevel()));
                    account4Web.setIoStatus(true);
                    account4Web.setTrackStatus(true);
                    account4Web.setStatus("已激活");
                    account4Web.setIo(new BigInteger("0"));
                    account4Web.setTrack(new BigInteger("0"));
                    list.add(account4Web);
                    logger.error("tkio task error :" + ac.getEmail());
                }

            }
        }
        //已过期的直接设置成过期
        List<Account> pastAccountList = accountRepository.findRootParentsPast(DateUtil.getBeforeDays(0));

        if(ValidateUtil.isValid(pastAccountList)){
            for(Account ac : pastAccountList){
                Account4Web account4Web = new Account4Web();
                account4Web.setPackageTypeId(ac.getPricelevel());
                account4Web.setAccountId(ac.getId());
                account4Web.setEmail(ac.getEmail());
                account4Web.setCompany(ac.getCompany());
                account4Web.setCreateDate(ac.getPubDate());
                account4Web.setStatus("已过期");
                account4Web.setPackageType(map.get(ac.getPricelevel()));
                account4Web.setPastDate(ac.getPastDate());
                account4Web.setIoStatus(false);
                account4Web.setTrackStatus(false);
                account4Web.setUser(ac.getName());
                account4Web.setTell(ac.getPhone());
                account4Web.setBussinessMan(ac.getBussinessman());
                if(saleMap.containsKey(ac.getBussinessman())){
                    account4Web.setSaleEamil(saleMap.get(ac.getBussinessman()));
                }
                list.add(account4Web);
            }
        }

        //禁用账号
        List<Account> accountList = accountRepository.findRootParentsForbiden();
        if(ValidateUtil.isValid(accountList)){
            for(Account ac : accountList){
                Account4Web account4Web = new Account4Web();
                account4Web.setPackageTypeId(ac.getPricelevel());
                account4Web.setAccountId(ac.getId());
                account4Web.setEmail(ac.getEmail());
                account4Web.setCompany(ac.getCompany());
                account4Web.setCreateDate(ac.getPubDate());
                account4Web.setStatus("已禁用");
                account4Web.setPackageType(map.get(ac.getPricelevel()));
                account4Web.setPastDate(ac.getPastDate());
                account4Web.setIoStatus(false);
                account4Web.setTrackStatus(false);
                account4Web.setUser(ac.getName());
                account4Web.setTell(ac.getPhone());
                account4Web.setBussinessMan(ac.getBussinessman());
                if(saleMap.containsKey(ac.getBussinessman())){
                    account4Web.setSaleEamil(saleMap.get(ac.getBussinessman()));
                }
                list.add(account4Web);
            }
        }
        account4WebRepository.save(list);
        logger.info("tkio task end :" + System.currentTimeMillis());
    }
}
