package track.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import track.model.Campaign;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public interface TrackCampaignRepository
        extends JpaRepository<Campaign, Long>
{

    @Query(value = "select count(*) from campaign where app  in ?1 and pub_date >= ?2 and pub_date <= ?3", nativeQuery = true)
    BigInteger countByAccount(List<Long> appids, String startDate, String endDate);
}
