package common.repository;

import common.model.Auth;
import common.model.Menu;
import common.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface AuthRepository extends JpaRepository<Auth, Long> {

    Auth findByUser(Long user);
    @Query(value="SELECT * from `auth` where user in ?1",nativeQuery=true)
    List<Auth> findAllByUsers(List<Long> ids);

}
