package common.repository;

import common.model.ContractBody;
import common.model.ContractIncrement;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface ContractIncrementRepository extends JpaRepository<ContractIncrement, Long> {

    @Query(value = "SELECT * from contract_increment where code = ?1", nativeQuery = true)
    ContractIncrement findByCode(String code);
}
