package common.repository;

import common.model.Contract;
import common.model.Role;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Transactional
public interface ContractRepository extends JpaRepository<Contract, Long> {

    @Query(value="select count(*) from contract where ds = ?1",nativeQuery=true)
    BigInteger countNumByDs(String ds);

    @Query(value="select count(*) from contract where email = ?1 and platform = ?2",nativeQuery=true)
    BigInteger countNumByEmail(String email, String platfrom);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 and status!='del' order by ds desc",nativeQuery=true)
    List<Contract> findByDs(String startDate, String endDate, String platfrom);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 and create_account in ?4 and status!='del' order by ds desc",nativeQuery=true)
    List<Contract> findByDsAndRoile(String startDate, String endDate, String platfrom, List<Long> userids);

    @Query(value="select * from contract where contract_code = ?1",nativeQuery=true)
    Contract findByCode(String contract_code);

    @Query(value="SELECT * from contract where platform = ?1 and type = 'main'",nativeQuery=true)
    List<Contract> findByPlatform(String platform);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3",nativeQuery=true)
    List<Contract> findByPlatformAndEmail(String platform, String email, String type);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3 order by ds,end_date desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailLimit1(String platform, String email,String type);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3 and price_level = ?4 order by ds desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailAndPricelevelLimit1(String platform, String email,String type, Long priceLevel);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and (status = 'wait' or status = 'executing') and type = 'main' order by ds desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailLimitVaild(String platform, String email);

    @Query(value="SELECT * from contract where start_date = ?1  and status <> 'cancel'",nativeQuery=true)
    List<Contract> findByStartDate(String startDate);

    @Query(value="SELECT * from contract where end_date <= ?1 and (status <> 'end' or status <> 'cancel')",nativeQuery=true)
    List<Contract> findByEndDate(String endDate);

    @Query(value = "select count(*) from contract where my_body_code = ?1",nativeQuery = true)
    BigInteger findcountContract(String platform);

    @Query(value = "select new map( c.id as id, c.contractCode as contractCode ) from Contract c where c.platform in ?1 and c.contractCode is not null and c.contractCode <> 'null' and c.status <>'del'")
    List<Map> contractCodePlatform(List<String> platform);

    @Query(value = "select * from contract where platform = ?1 and contract_code = ?2",nativeQuery = true)
    Contract findByCodePlatform(String contractCode, String platform);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform in ?3 and id in ?4 and status!='del' order by ds desc",nativeQuery=true)
    List<Contract> findByDsRelation(String startDate, String endDate, List<String> platform, List<String> contractIds);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform in ?3 and create_account in ?4 and id in ?5 and status!='del' order by ds desc",nativeQuery=true)
    List<Contract> findByDsAndRoileRelation(String startDate, String endDate, List<String> platform, List<Long> create_account, List<String> contractIds);


    @Query(value = "select new map( c.id as id, c.contractCode as contractCode ) from Contract c where c.platform in ?1 and c.contractCode is not null and c.contractCode <> 'null' ")
    List<Contract> contractCodePlatformNot(List<String> plats, List<Long> ids);


    @Query(value = "select contract_code from contract where my_body_code = ?1 order by code_num desc limit 1",nativeQuery = true)
    String findLastCode(String code);


    @Query(value = "select * from contract where id = ?1 union all select * from contract where id = ?2",nativeQuery = true)
    List<Contract> findByTwoIds(Long relationContract, Long relationContract1);

    @Query(value="SELECT * from contract where platform =?1 and email = ?2  and (status <> 'end' or status <> 'cancel')",nativeQuery=true)
    List<Contract> findByPlatformAndEmailStatus(String platgorm, String email);

    @Query(value = "select * from contract where contract_code =?2 and platform = ?1 ",nativeQuery = true)
    Contract findOneByCode(String platform, String contractId);

    @Query(value = "select * from contract where start_date >= ?1 and start_date <= ?2 and platform in ?3 and my_body_code in ?4 and id in ?5 and status!='del' order by ds desc",nativeQuery = true)
    List<Contract> findByDsContractBody(String startDate, String endDate, List<String> platforms, List bodyids, List<String> ids);

    @Query(value = "select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 and my_body_code in ?4 and status!='del' order by ds desc",nativeQuery = true)
    List<Contract> findByDsContractBody(String startDate, String endDate, String platform, List bodyids);

    @Query(value = "select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 and sale in ?4 and status!='del' order by ds desc",nativeQuery = true)
    List<Contract> findByDsContractSalse(String startDate, String endDate, String platform, List salseid);

    @Query(value = "select * from contract where start_date >= ?1 and start_date <= ?2 and platform in ?3 and sale in ?4  and id in ?5 and status!='del' order by ds desc",nativeQuery = true)
    List<Contract> findByDsContractSalse(String startDate, String endDate, List<String> platforms, List salseid, List<String> ids);

    @Query(value = "select contract_code,my_body_code,sale,platform from contract where contract_code in ?1",nativeQuery = true)
    List<Object[]> findByContractCode(List<String> codesList);

    @Query(value="select * from contract where start_date >= ?1 and start_date <=?2 and end_date >= ?1 and create_time <= ?2 and platform=?3",nativeQuery = true)
    List<Contract> findShareContranctByDate(String startDate, String endDate, String platform);

    @Query(value="select * from contract where start_date >= ?1 and start_date <=?2 and end_date >= ?1 and create_time <= ?2 and platform=?3   and my_body_code = ?4",nativeQuery = true)
    List<Contract> findShareContranctByDate(String startDate, String endDate, String platform, String bodyCode);

    @Query(value="select * from contract where start_date >= ?1 and start_date <=?2 and end_date >= ?1 and create_time <= ?2 and platform=?3 and (my_body_name like %?5% or customer_body like %?5% or contract_code like %?5%)",nativeQuery = true)
    List<Contract> findShareContranctByDateSerche(String startDate, String endDate, String platform, String serchName);

    @Query(value="select * from contract where start_date >= ?1 and start_date <=?2 and end_date >= ?1 and create_time <= ?2 and platform=?3   and my_body_code = ?4  and (my_body_name like %?5% or customer_body like %?5% or contract_code like %?5%)",nativeQuery = true)
    List<Contract> findShareContranctByDate(String startDate, String endDate, String platform, String bodyCode, String serchName);
}
