package common.repository;

import common.model.Menu;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface MenuRepository extends JpaRepository<Menu, Long> {
	
	@Query(value="select * from menu where parent <> 0",nativeQuery=true)
	List<Menu> listAllSonMenu();
	@Query(value="select * from menu where parent = 0",nativeQuery=true)
	List<Menu> listAllParentMenu();
	
	@Query(value="select * from menu where id in ?1",nativeQuery=true)
	List<Menu> listMenuByIds(List<String> idList);

	
}
