package common.repository;

import common.model.Auth;
import common.model.BackVisit;
import common.model.Payment;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface PaymentRepository extends JpaRepository<Payment, Long> {

    @Query(value = "select * from payment where account_id  = ?1 and ds >= ?2 and ds <= ?3 and platform = ?4", nativeQuery = true)
    List<Payment> findAll(Long accountId, String startDate, String endDate, String platform);

    @Query(value = "select * from payment where platform = ?1", nativeQuery = true)
    List<Payment> findAllByPlatform(String platform);
}
