package common.repository;

import common.model.Sales;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface SalesRepository extends JpaRepository<Sales, Long> {

    @Query(value = "select * from sales where status = ?1 order by area_type,id",nativeQuery = true)
    List<Sales> findSaleByStatus(Integer status);


    @Query(value = "select * from sales where id = ?1 union all select * from sales where id =?2",nativeQuery = true)
    List<Sales> findByTwoId(Long sale, Long sale1);

    @Query(value = "select * from sales where status = '0' order by area_type,id",nativeQuery = true)
    List<Sales> findAllByStatusOn( );

}
