package common.service.impl;

import common.model.Auth;
import common.model.User;
import common.repository.AuthRepository;
import common.repository.ContractBodyRepository;
import common.service.AuthService;
import dic.RoleEnum;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
public class AuthServiceImpl implements AuthService {

    @Autowired
    AuthRepository authRepository;

    @Autowired
    ContractBodyRepository contractBodyRepository;

    @Override
    public Map<String, Object> getAuthExtends(User loginAccount) {

        Auth auth = authRepository.findByUser(loginAccount.getId());

        Map<String, Object> collect = new HashMap<>();

        if(RoleEnum.FINANCE.getKey().equals(loginAccount.getRole()) || RoleEnum.PM.getKey().equals(loginAccount.getRole())){
            //财务  按签约主体查看
            List<String> authArrs   =  JSONArray.fromObject(auth.getAuthExtend());
            collect   = authArrs.stream().collect(Collectors.toMap(t -> t, t -> t));

        }else if(RoleEnum.SALSEMAN.getKey().equals(loginAccount.getRole())){
            //销售 按签约合同人查看
            List<Integer> authArrs   =  JSONArray.fromObject(auth.getAuthExtend());
            collect   = authArrs.stream().collect(Collectors.toMap(t -> t.toString(), t -> t));
        }

        if(collect.size()>0){

            collect.put("needcheck","1");
        }

        return collect;
    }
}
