package common.task;

import common.model.Contract;
import common.repository.ContractRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zxy on 2017/12/26.
 */
public class ContractTask
{
    private static Logger logger = LoggerFactory.getLogger(ContractTask.class);
    @Autowired
    ContractRepository contractRepository;

    public void task(){
        List<Contract> contractList = contractRepository.findByStartDate(DateUtil.getBeforeDays(0));
        if(ValidateUtil.isValid(contractList)){
            List<Contract> list = new ArrayList<>();
            for(Contract c : contractList){
                c.setStatus("executing");
                list.add(c);
            }
            contractRepository.save(list);
        }

        List<Contract> contractList2 = contractRepository.findByEndDate(DateUtil.getBeforeDays(0));
        if(ValidateUtil.isValid(contractList2)){
            List<Contract> list = new ArrayList<>();
            for(Contract c : contractList2){
                c.setStatus("end");
                list.add(c);
            }
            contractRepository.save(list);
        }
    }


}
