package tkio.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;

@Entity
public class Campaign
{

    private Long id;
    private Long app;
    private String os;
    private String type;
    private Long channel;
    private String channelCategory;
    private String channelType;
    private String campaignid;

    private String name;
    private String callback;
    private String url;
    private String surl;
    private Integer addParam;
    private String campaignpackid;

    private String specialKeys;

    private String advertiserid;

    private String bundleid;

    private Boolean awssuccess = false;

    private Date createTime;
    private Long createAccount;
    private Date modifyTime;
    private Long modifyAccount;
    private Boolean delFlag = false;

    private Long account;

    private String holderids;
    private String pack_channelid;
    private int batchNumber;

    private int startNumber;
    private String campaignName;

    @Transient
    public int getStartNumber() {
        return startNumber;
    }

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    @Transient
    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    @Transient
    public int getBatchNumber()
    {
        return batchNumber;
    }

    public void setBatchNumber(int batchNumber)
    {
        this.batchNumber = batchNumber;
    }

    @Transient
    public String getHolderids()
    {
        return holderids;
    }

    public void setHolderids(String holderids)
    {
        this.holderids = holderids;
    }

    public Long getAccount()
    {
        return account;
    }

    public void setAccount(Long account)
    {
        this.account = account;
    }

    public Campaign()
    {
        super();
    }

    public Campaign(String campaignid, String name)
    {
        this.campaignid = campaignid;
        this.name = name;
    }

    public Long getApp()
    {
        return app;
    }

    public String getCallback()
    {
        return callback;
    }

/*	public Long getCampaignGroup() {
        return campaignGroup;
	}*/

    public Long getChannel()
    {
        return channel;
    }

    @Id
    @GeneratedValue
    public Long getId()
    {
        return id;
    }

    public String getName()
    {
        return name;
    }

    public String getSurl()
    {
        return surl;
    }

    public String getType()
    {
        return type;
    }

    public String getUrl()
    {
        return url;
    }

    public void setApp(Long app)
    {
        this.app = app;
    }

    public void setCallback(String callback)
    {
        this.callback = callback;
    }

/*	public void setCampaignGroup(Long campaignGroup) {
		this.campaignGroup = campaignGroup;
	}*/

    public void setChannel(Long channel)
    {
        this.channel = channel;
    }

    public String getChannelCategory()
    {
        return channelCategory;
    }

    public void setChannelCategory(String channelCategory)
    {
        this.channelCategory = channelCategory;
    }

    public String getChannelType()
    {
        return channelType;
    }

    public void setChannelType(String channelType)
    {
        this.channelType = channelType;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public void setSurl(String surl)
    {
        this.surl = surl;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getSpecialKeys()
    {
        return specialKeys;
    }

    public void setSpecialKeys(String specialKeys)
    {
        this.specialKeys = specialKeys;
    }

    public Integer getAddParam()
    {
        return addParam;
    }

    public void setAddParam(Integer addParam)
    {
        this.addParam = addParam;
    }

    public String getOs()
    {
        return os;
    }

    public void setOs(String os)
    {
        this.os = os;
    }

    public boolean isAwssuccess()
    {
        return awssuccess;
    }

    public void setAwssuccess(boolean awssuccess)
    {
        this.awssuccess = awssuccess;
    }

    public String getCampaignpackid()
    {
        return campaignpackid;
    }

    public void setCampaignpackid(String campaignpackid)
    {
        this.campaignpackid = campaignpackid;
    }

    public String getAdvertiserid()
    {
        return advertiserid;
    }

    public void setAdvertiserid(String advertiserid)
    {
        this.advertiserid = advertiserid;
    }

    public String getBundleid()
    {
        return bundleid;
    }

    public void setBundleid(String bundleid)
    {
        this.bundleid = bundleid;
    }

    public Date getCreateTime()
    {
        return createTime;
    }

    public void setCreateTime(Date createTime)
    {
        this.createTime = createTime;
    }

    public Date getModifyTime()
    {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime)
    {
        this.modifyTime = modifyTime;
    }

    public Boolean getDelFlag()
    {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag)
    {
        this.delFlag = delFlag;
    }

    public String getCampaignid()
    {
        return campaignid;
    }

    public void setCampaignid(String campaignid)
    {
        this.campaignid = campaignid;
    }

    public Long getCreateAccount()
    {
        return createAccount;
    }

    public void setCreateAccount(Long createAccount)
    {
        this.createAccount = createAccount;
    }

    public Long getModifyAccount()
    {
        return modifyAccount;
    }

    public void setModifyAccount(Long modifyAccount)
    {
        this.modifyAccount = modifyAccount;
    }

    public String getPack_channelid()
    {
        return pack_channelid;
    }

    public void setPack_channelid(String pack_channelid)
    {
        this.pack_channelid = pack_channelid;
    }

    public Boolean getAwssuccess()
    {
        return awssuccess;
    }

    public void setAwssuccess(Boolean awssuccess)
    {
        this.awssuccess = awssuccess;
    }

    @Override
    public String toString()
    {
        return "Campaign{" +
                "id=" + id +
                ", app=" + app +
                ", os='" + os + '\'' +
                ", type='" + type + '\'' +
                ", channel=" + channel +
                ", channelCategory='" + channelCategory + '\'' +
                ", channelType='" + channelType + '\'' +
                ", campaignid='" + campaignid + '\'' +
                ", name='" + name + '\'' +
                ", callback='" + callback + '\'' +
                ", url='" + url + '\'' +
                ", surl='" + surl + '\'' +
                ", addParam=" + addParam +
                ", campaignpackid='" + campaignpackid + '\'' +
                ", specialKeys='" + specialKeys + '\'' +
                ", advertiserid='" + advertiserid + '\'' +
                ", bundleid='" + bundleid + '\'' +
                ", awssuccess=" + awssuccess +
                ", createTime=" + createTime +
                ", createAccount=" + createAccount +
                ", modifyTime=" + modifyTime +
                ", modifyAccount=" + modifyAccount +
                ", delFlag=" + delFlag +
                ", account=" + account +
                ", holderids='" + holderids + '\'' +
                ", pack_channelid='" + pack_channelid + '\'' +
                ", batchNumber=" + batchNumber +
                '}';
    }
}
