package tkio.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * Created by song on 2017/10/19.
 */
@Entity
public class PackageType {
    private Long id;
    private String packageName;
    private String originalName;
    private BigInteger trackFlow;
    private BigInteger ioFlow;
    private Integer appNum;

    /**
     * 价格
     */
    private BigDecimal price; //价格

    /**
     * 数据量
     **/
    private Integer dataSurlNum;        //创建短链数
    private Integer dataConversionFunnelNum;    // 转化漏斗数
    private Integer dataUserGroupNum;            //用户分群数

    /**
     * 核心功能
     **/
    private String funcQueryElapsed;        //查询速度
    private String funcRealtime;            //数据实时性
    private Boolean funcInstallAttibution;        //实时激活归因
    private Boolean funcCustomRetainAnalysis;        //自定义留存分析
    private Boolean funcCustomConversionFunnel;        //自定义漏斗
    private Boolean funcCustomUserGroup;        //自定义用户群
    private Boolean funcMultiAnalysisAndOLAP;        //多维分析和OLAP

    /**
     * 管理功能
     **/
    private Boolean funcMngAuth;        //权限管理
    private Boolean funcMngSubAccount;        //子账号管理
    private Boolean funcMngDefendCheatSetting;        //防作弊参数设置
    private Boolean funcMngUserAttibute;//用户属性管理
    private Boolean funcMngAppEvent;//APP事件管理
    private Boolean funcMngCampaign;//推广活动管理
    private Boolean funcMngRealtimeCallback;//推广实时回调

    /**
     * 数据接入
     *
     * @return
     */
    private Boolean integrateCatFront;//前端埋点
    private Boolean integrateCatEnd;//后端埋点
    private Boolean integrateRestAPI;//REST API
    private Boolean integrateH5Page;//H5网页
    private Boolean integratePCPage;//PC 网页

    /**
     * 平台功能
     *
     * @return
     */
    private Boolean platformExport;//数据导出
    private Integer platformUserProfile;//用户画像能力
    private Boolean platformDataStore;//数据存储
    private Boolean platformHive;//Hive访问数据
    private Boolean platformPresto;//Presto访问数据
    private Boolean platformCustomReport;//自定义报表设计
    private Boolean platformServiceSupport; //7*24小时客户服务
    private Boolean platformCustomDataAnalysis; //专属数据分析师


    private String type;

    @Transient
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getAppNum() {
        return appNum;
    }

    public void setAppNum(Integer appNum) {
        this.appNum = appNum;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getOriginalName() {
        return originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public BigInteger getTrackFlow() {
        return trackFlow;
    }

    public void setTrackFlow(BigInteger trackFlow) {
        this.trackFlow = trackFlow;
    }

    public BigInteger getIoFlow() {
        return ioFlow;
    }

    public void setIoFlow(BigInteger ioFlow) {
        this.ioFlow = ioFlow;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getDataSurlNum() {
        return dataSurlNum;
    }

    public void setDataSurlNum(Integer dataSurlNum) {
        this.dataSurlNum = dataSurlNum;
    }


    public Integer getDataConversionFunnelNum() {
        return dataConversionFunnelNum;
    }

    public void setDataConversionFunnelNum(Integer dataConversionFunnelNum) {
        this.dataConversionFunnelNum = dataConversionFunnelNum;
    }

    public Integer getDataUserGroupNum() {
        return dataUserGroupNum;
    }

    public void setDataUserGroupNum(Integer dataUserGroupNum) {
        this.dataUserGroupNum = dataUserGroupNum;
    }

    public String getFuncQueryElapsed() {
        return funcQueryElapsed;
    }

    public void setFuncQueryElapsed(String funcQueryElapsed) {
        this.funcQueryElapsed = funcQueryElapsed;
    }

    public String getFuncRealtime() {
        return funcRealtime;
    }

    public void setFuncRealtime(String funcRealtime) {
        this.funcRealtime = funcRealtime;
    }

    public Boolean getFuncInstallAttibution() {
        return funcInstallAttibution;
    }

    public void setFuncInstallAttibution(Boolean funcInstallAttibution) {
        this.funcInstallAttibution = funcInstallAttibution;
    }

    public Boolean getFuncCustomRetainAnalysis() {
        return funcCustomRetainAnalysis;
    }

    public void setFuncCustomRetainAnalysis(Boolean funcCustomRetainAnalysis) {
        this.funcCustomRetainAnalysis = funcCustomRetainAnalysis;
    }

    public Boolean getFuncCustomConversionFunnel() {
        return funcCustomConversionFunnel;
    }

    public void setFuncCustomConversionFunnel(Boolean funcCustomConversionFunnel) {
        this.funcCustomConversionFunnel = funcCustomConversionFunnel;
    }

    public Boolean getFuncCustomUserGroup() {
        return funcCustomUserGroup;
    }

    public void setFuncCustomUserGroup(Boolean funcCustomUserGroup) {
        this.funcCustomUserGroup = funcCustomUserGroup;
    }

    public Boolean getFuncMultiAnalysisAndOLAP() {
        return funcMultiAnalysisAndOLAP;
    }

    public void setFuncMultiAnalysisAndOLAP(Boolean funcMultiAnalysisAndOLAP) {
        this.funcMultiAnalysisAndOLAP = funcMultiAnalysisAndOLAP;
    }

    public Boolean getFuncMngAuth() {
        return funcMngAuth;
    }

    public void setFuncMngAuth(Boolean funcMngAuth) {
        this.funcMngAuth = funcMngAuth;
    }

    public Boolean getFuncMngSubAccount() {
        return funcMngSubAccount;
    }

    public void setFuncMngSubAccount(Boolean funcMngSubAccount) {
        this.funcMngSubAccount = funcMngSubAccount;
    }

    public Boolean getFuncMngDefendCheatSetting() {
        return funcMngDefendCheatSetting;
    }

    public void setFuncMngDefendCheatSetting(Boolean funcMngDefendCheatSetting) {
        this.funcMngDefendCheatSetting = funcMngDefendCheatSetting;
    }

    public Boolean getFuncMngUserAttibute() {
        return funcMngUserAttibute;
    }

    public void setFuncMngUserAttibute(Boolean funcMngUserAttibute) {
        this.funcMngUserAttibute = funcMngUserAttibute;
    }

    public Boolean getFuncMngAppEvent() {
        return funcMngAppEvent;
    }

    public void setFuncMngAppEvent(Boolean funcMngAppEvent) {
        this.funcMngAppEvent = funcMngAppEvent;
    }

    public Boolean getFuncMngCampaign() {
        return funcMngCampaign;
    }

    public void setFuncMngCampaign(Boolean funcMngCampaign) {
        this.funcMngCampaign = funcMngCampaign;
    }

    public Boolean getFuncMngRealtimeCallback() {
        return funcMngRealtimeCallback;
    }

    public void setFuncMngRealtimeCallback(Boolean funcMngRealtimeCallback) {
        this.funcMngRealtimeCallback = funcMngRealtimeCallback;
    }

    public Boolean getIntegrateCatFront() {
        return integrateCatFront;
    }

    public void setIntegrateCatFront(Boolean integrateCatFront) {
        this.integrateCatFront = integrateCatFront;
    }

    public Boolean getIntegrateCatEnd() {
        return integrateCatEnd;
    }

    public void setIntegrateCatEnd(Boolean integrateCatEnd) {
        this.integrateCatEnd = integrateCatEnd;
    }

    public Boolean getIntegrateRestAPI() {
        return integrateRestAPI;
    }

    public void setIntegrateRestAPI(Boolean integrateRestAPI) {
        this.integrateRestAPI = integrateRestAPI;
    }

    public Boolean getIntegrateH5Page() {
        return integrateH5Page;
    }

    public void setIntegrateH5Page(Boolean integrateH5Page) {
        this.integrateH5Page = integrateH5Page;
    }

    public Boolean getIntegratePCPage() {
        return integratePCPage;
    }

    public void setIntegratePCPage(Boolean integratePCPage) {
        this.integratePCPage = integratePCPage;
    }

    public Boolean getPlatformExport() {
        return platformExport;
    }

    public void setPlatformExport(Boolean platformExport) {
        this.platformExport = platformExport;
    }

    public Integer getPlatformUserProfile() {
        return platformUserProfile;
    }

    public void setPlatformUserProfile(Integer platformUserProfile) {
        this.platformUserProfile = platformUserProfile;
    }

    public Boolean getPlatformDataStore() {
        return platformDataStore;
    }

    public void setPlatformDataStore(Boolean platformDataStore) {
        this.platformDataStore = platformDataStore;
    }

    public Boolean getPlatformHive() {
        return platformHive;
    }

    public void setPlatformHive(Boolean platformHive) {
        this.platformHive = platformHive;
    }

    public Boolean getPlatformPresto() {
        return platformPresto;
    }

    public void setPlatformPresto(Boolean platformPresto) {
        this.platformPresto = platformPresto;
    }

    public Boolean getPlatformCustomReport() {
        return platformCustomReport;
    }

    public void setPlatformCustomReport(Boolean platformCustomReport) {
        this.platformCustomReport = platformCustomReport;
    }

    public Boolean getPlatformServiceSupport() {
        return platformServiceSupport;
    }

    public void setPlatformServiceSupport(Boolean platformServiceSupport) {
        this.platformServiceSupport = platformServiceSupport;
    }

    public Boolean getPlatformCustomDataAnalysis() {
        return platformCustomDataAnalysis;
    }

    public void setPlatformCustomDataAnalysis(Boolean platformCustomDataAnalysis) {
        this.platformCustomDataAnalysis = platformCustomDataAnalysis;
    }
}
